package com.agilex.healthcare.mobilehealthplatform.datalayer.calendar;

import javax.annotation.Resource;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientPublicKey;
import org.springframework.stereotype.Service;

@Service
public class CalendarKeyDataLayerRepo implements CalendarKeyDataLayer {

	@Resource
	PatientPublicKeyDao dao;

	public String fetchKeyByPatient(PatientIdentifier patientIdentifier) {
		return createKeyForPatient(patientIdentifier);
	}

	public String fetchPatientByKey(String key) {
		PatientPublicKey patientPublicKey = dao.getPatientId(key);

        if (patientPublicKey == null)
            return null;

		return patientPublicKey.getPatientId();
	}

	public String createKeyForPatient(PatientIdentifier patientIdentifier) {
        PatientPublicKey publicKey = dao.getKey(patientIdentifier.getUniqueId());

        if (publicKey != null && publicKey.getPublicKey() != null)
            return publicKey.getPublicKey();

		PatientPublicKey patientPublicKeyToSave = new PatientPublicKey();
        patientPublicKeyToSave.setPatientId(patientIdentifier.getUniqueId());

		PatientPublicKey savedPatientPublicKey = dao.save(patientPublicKeyToSave);
		return savedPatientPublicKey.getPublicKey();
	}

	public void deleteKeyForPatient(PatientIdentifier patientIdentifier) {
		PatientPublicKey patientPublicKeyToDelete = dao.getKey(patientIdentifier.getUniqueId());
		dao.delete(patientPublicKeyToDelete);
	}
}
