package com.agilex.healthcare.mobilehealthplatform.datalayer.calendar;

import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvent;
import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.Date;

@Entity
@Table(name = "CALENDAR_EVENTS")
public class CalendarEventPo extends PersistenceObject implements Transformable<CalendarEvent> {
    private static final long serialVersionUID = 4274014244613945572L;

    private String title;
    private String notes;
    private Date startDate;
    private int duration;
    private int alertDuration;

    public CalendarEventPo() {}

    public CalendarEventPo(CalendarEvent dto) {
        setId(dto.getUniqueId());
        setUserId(dto.getPatientId());
        setAlertDuration(dto.getAlertDuration());
        setDuration(dto.getDuration());
        setNotes(dto.getNotes());
        setTitle(dto.getTitle());
        setStartDate(dto.getStartDate());
    }

    @Id
    @GeneratedValue(generator="calendar_event_id_generator")
    @GenericGenerator(name="calendar_event_id_generator", strategy = "uuid")
    @Column(name="ID", nullable=false)
    public String getId() {
        return super.getId();
    }

    @Column(name="PATIENT_ID")
    public String getUserId() {
        return super.getUserId();
    }

    @Column(name="TITLE")
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name="NOTES")
    public String getNotes() {
        return notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Column(name="START_DATE")
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Column(name="DURATION")
    public int getDuration() {
        return duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Column(name="ALERT_DURATION")
    public int getAlertDuration() {
        return alertDuration;
    }

    public void setAlertDuration(int alertDuration) {
        this.alertDuration = alertDuration;
    }

    @Override
    public CalendarEvent create() {
        CalendarEvent event = new CalendarEvent();

        event.setUniqueId(getId());
        event.setPatientId(getUserId());
        event.setAlertDuration(getAlertDuration());
        event.setDuration(getDuration());
        event.setNotes(getNotes());
        event.setStartDate(getStartDate());
        event.setTitle(getTitle());

        return event;
    }
}
