package com.agilex.healthcare.mobilehealthplatform.datalayer.calendar;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;
import com.agilex.healthcare.mobilehealthplatform.domain.*;

@Service
public class CalendarEventDataLayerRepo implements CalendarEventDataLayer {

	@Resource
    CalendarEventDao calendarEventDao;

	public CalendarEvents fetchCalendarEvents(String patientId) {
		return calendarEventDao.get(patientId);
	}

	public CalendarEvent saveCalendarEvent(CalendarEvent calendarEvent) {
		return calendarEventDao.save(calendarEvent);
	}
	
	// Package protected - only available for tests
	void deleteCalendarEvent(CalendarEvent calendarEvent) {
        calendarEventDao.delete(calendarEvent);
	}
}
