package com.agilex.healthcare.mobilehealthplatform.datalayer.calendar;

import com.agilex.healthcare.mobilehealthplatform.datalayer.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.*;

import java.util.ArrayList;
import java.util.List;

@Repository
public class CalendarEventDao extends AbstractDao {
    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(CalendarEventDao.class);

    private static final String WHERE_PATIENT_ID = "from CalendarEventPo where userId = :patientId ";

    public CalendarEvents get(String patientId) {
        if (logger.isDebugEnabled()) logger.debug("Retrieving Calendar Events for patient");

        JpaFilter jpaFilter = new JpaNullFilter();
        SimpleEntityManager<CalendarEventPo> simpleEntityManager = new SimpleEntityManager<CalendarEventPo>(WHERE_PATIENT_ID, entityManager);

        List<CalendarEventPo> results = simpleEntityManager.get(patientId, jpaFilter, CalendarEventPo.class);

        List<Transformable<? extends DomainTransferObject>> transformableList = createTransformableList(results);

        CalendarEvents events = new CalendarEvents();
        Mapper.add(transformableList, events);

        return events;
    }

    private List<Transformable<? extends DomainTransferObject>> createTransformableList(List<CalendarEventPo> results) {
        List<Transformable<? extends DomainTransferObject>> transformableList = new ArrayList<Transformable<? extends DomainTransferObject>>();
        transformableList.addAll(results);

        return transformableList;
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public CalendarEvent save(CalendarEvent event) {
        if (logger.isDebugEnabled()) logger.debug("Saving Calendar Event");

        SimpleEntityManager<CalendarEventPo> simpleEntityManager = new SimpleEntityManager<CalendarEventPo>(entityManager);
        CalendarEventPo po = simpleEntityManager.save(new CalendarEventPo(event));

        if (logger.isDebugEnabled()) logger.debug("Saved Calendar Eventß");

        return po.create();
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public void delete(CalendarEvent event) {
        if (logger.isDebugEnabled()) logger.debug("Deleting Calendar Event");

        SimpleEntityManager<CalendarEventPo> simpleEntityManager = new SimpleEntityManager<CalendarEventPo>(entityManager);
        simpleEntityManager.delete(event, CalendarEventPo.class);
    }
}
