package com.agilex.healthcare.mobilehealthplatform.datalayer.audit;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="AUDIT_LOG")
public class AuditLogPo extends PersistenceObject {

	private static final long serialVersionUID = -112122983527516063L;

	private String type;
	private String subType;
	private Date date;
	private String details;
	
	@Id
	@Column(name="AUDIT_ID")
	@GeneratedValue(generator="audit_log_id_generator")
	@GenericGenerator(name="audit_log_id_generator", strategy = "uuid")
	public String getId() {
		return super.getId();
	}
	
	public void setId(String id) {
		super.setId(id);
	}
	
	@Column(name="USER_ID")
	public String getUserId() {
		return super.getUserId();
	}
	
	public void setUserId(String userId) {
		super.setUserId(userId);
	}

	@Column(name = "AUDIT_TYPE")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Column(name = "AUDIT_SUBTYPE")
	public String getSubType() {
		return subType;
	}

	public void setSubType(String subType) {
		this.subType = subType;
	}

	@Column(name = "AUDIT_DATE")
	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	@Column(name = "DETAILS")
	public String getDetails() {
		return details;
	}

	public void setDetails(String details) {
		this.details = details;
	}
}
