package com.agilex.healthcare.mobilehealthplatform.datalayer.audit;

import com.agilex.healthcare.mobilehealthplatform.domain.AuditLog;
import com.agilex.healthcare.mobilehealthplatform.domain.AuditLogs;
import com.agilex.healthcare.mobilehealthplatform.datalayer.audit.AuditLogPo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.AbstractMapper;

public class AuditLogMapper extends AbstractMapper<AuditLog, AuditLogs, AuditLogPo> {

	@Override
	public AuditLog toDto(AuditLogPo po) {
		AuditLog dto = new AuditLog();
		
		dto.setId(po.getId());
		dto.setDate(po.getDate());
		dto.setDetails(po.getDetails());
		dto.setSubType(po.getSubType());
		dto.setType(po.getType());
		dto.setUserId(po.getUserId());
		
		return dto;
	}

	@Override
	public AuditLogPo toPo(AuditLog dto) {
		AuditLogPo po = new AuditLogPo();
		
		po.setId(dto.getId());
		po.setDate(dto.getDate());
		po.setDetails(dto.getDetails());
		po.setSubType(dto.getSubType());
		po.setType(dto.getType());
		po.setUserId(dto.getUserId());
		
		return po;
	}

}
