package com.agilex.healthcare.mobilehealthplatform.datalayer.audit;

import java.util.List;

import javax.annotation.Resource;

import com.agilex.healthcare.mobilehealthplatform.domain.AuditLog;
import com.agilex.healthcare.mobilehealthplatform.domain.AuditLogs;
import com.agilex.healthcare.mobilehealthplatform.datalayer.audit.AuditLogMapper;

public class AuditLogDataLayerPed implements AuditLogDataLayer {

	@Resource
	AuditLogDao auditLogDao;
	private AuditLogMapper mapper = new AuditLogMapper();

	public AuditLogs fetchAuditLogs(String userId, AuditLogFilter filter) {
		List<AuditLogPo> auditLogPos = auditLogDao.fetchAuditLogs(userId);
		AuditLogs auditLogs = mapper.toDtoCollection(auditLogPos, new AuditLogs());
		return AuditLogFilterer.filter(auditLogs, filter);
	}

	public AuditLog fetchAuditLog(String userId, String auditLogId) {
		AuditLogPo auditLogPo = auditLogDao.fetchAuditLog(userId, auditLogId);
		return mapper.toDto(auditLogPo);
	}

	public AuditLog saveAudit(AuditLog auditLog) {
		AuditLogPo savedAuditLogPo = auditLogDao.saveAuditLog(mapper.toPo(auditLog));
		return mapper.toDto(savedAuditLogPo);
	}

}
