package com.agilex.healthcare.mobilehealthplatform.datalayer.audit;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.TypedQuery;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.agilex.healthcare.mobilehealthplatform.datalayer.AbstractDao;
import com.agilex.healthcare.utility.NullChecker;

@Repository
public class AuditLogDao extends AbstractDao {
	
	public List<AuditLogPo> fetchAuditLogs(String userId) {
		String dbQuery = "from AuditLogPo al where al.userId = :userId";
		return executeQueryByUserId(dbQuery, userId);
	}

	public AuditLogPo fetchAuditLog(String userId, String auditLogId) {
		String dbQuery = "from AuditLogPo al where al.userId = :userId and al.id = :id";
		return executeQueryByAuditLogId(dbQuery, userId, auditLogId);
	}

	@Transactional(propagation = Propagation.REQUIRED)
	public AuditLogPo saveAuditLog(AuditLogPo auditLog) {
		return this.entityManager.merge(auditLog);
	}

	private List<AuditLogPo> executeQueryByUserId(String dbQuery, String userId) {
		TypedQuery<AuditLogPo> query = this.entityManager.createQuery(dbQuery, AuditLogPo.class);
		query.setParameter("userId", userId);

		List<AuditLogPo> results = query.getResultList();
		

		if (NullChecker.isNotNullish(results)) {
			return results;
		} else {
			return new ArrayList<AuditLogPo>();
		}
	}

	private AuditLogPo executeQueryByAuditLogId(String dbQuery, String userId, String auditLogId) {
		TypedQuery<AuditLogPo> query = this.entityManager.createQuery(dbQuery, AuditLogPo.class);
		query.setParameter("userId", userId);
		query.setParameter("id", auditLogId);

		List<AuditLogPo> results = query.getResultList();
		
		if (NullChecker.isNotNullish(results)) {
			return results.get(0);
		} else {
			return null;
		}
	}
}
