package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresult;

import java.util.Date;
import java.util.UUID;

import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResult;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssessmentCode;

public class PCLAssessmentResultGenerator {

	public AssessmentResult generateAssessmentResultFromScore(String userId, Date dateTaken, int score) {
		AssessmentResult assessmentResult = new AssessmentResult();
		assessmentResult.setUniqueId(UUID.randomUUID().toString());
		assessmentResult.setAssessmentId(AssessmentCode.ASSESSMENT_ID_PTSD);
		assessmentResult.setAuthenticationStrategy(AssessmentCode.AUTHENTICATION_STRATEGY_BASIC);
		assessmentResult.setPatientId(userId);
		assessmentResult.setDateTaken(dateTaken);
		assessmentResult.setScore(score);
		return assessmentResult;
	}
}
