package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresult;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.NotImplementedException;
import org.joda.time.DateTime;

import com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults.AssessmentResultDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResult;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResults;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssessmentCode;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;

public class PCLAssessmentResultDataLayerMock implements AssessmentResultDataLayer {
	private Map<String, AssessmentResults> mockStorage = new HashMap<String, AssessmentResults>();

	public PCLAssessmentResultDataLayerMock() {
		initMap();
	}

	private void initMap() {
		String patientId;
		int score;
		AssessmentResult mockResult;
		DateTime today = new DateTime();
		Date twoWeeksAgo = today.minusDays(14).toDate();

		// ALDIE DATA
		patientId = "PATID26";
		score = 17;
		mockResult = createMockResult(patientId, score, twoWeeksAgo);
		addResultToMockStorage(mockResult);

		score = 18;
		mockResult = createMockResult(patientId, score, twoWeeksAgo);
		addResultToMockStorage(mockResult);

		score = 35;
		mockResult = createMockResult(patientId, score, twoWeeksAgo);
		addResultToMockStorage(mockResult);

		score = 50;
		mockResult = createMockResult(patientId, score, twoWeeksAgo);
		addResultToMockStorage(mockResult);

		score = 80;
		mockResult = createMockResult(patientId, score, twoWeeksAgo);
		addResultToMockStorage(mockResult);

		// GALLOW DATA
		patientId = "D123401";
		score = 17;
		mockResult = createMockResult(patientId, score, twoWeeksAgo);
		addResultToMockStorage(mockResult);

		score = 18;
		mockResult = createMockResult(patientId, score, twoWeeksAgo);
		addResultToMockStorage(mockResult);

		score = 35;
		mockResult = createMockResult(patientId, score, twoWeeksAgo);
		addResultToMockStorage(mockResult);

		score = 50;
		mockResult = createMockResult(patientId, score, twoWeeksAgo);
		addResultToMockStorage(mockResult);

		score = 80;
		mockResult = createMockResult(patientId, score, twoWeeksAgo);
		addResultToMockStorage(mockResult);

		// OTHER DATA
		patientId = "testPatientId";
		score = 17;
		mockResult = createMockResult(patientId, score, twoWeeksAgo);
		addResultToMockStorage(mockResult);

		score = 18;
		mockResult = createMockResult(patientId, score, twoWeeksAgo);
		addResultToMockStorage(mockResult);

		score = 35;
		mockResult = createMockResult(patientId, score, twoWeeksAgo);
		addResultToMockStorage(mockResult);

		score = 50;
		mockResult = createMockResult(patientId, score, twoWeeksAgo);
		addResultToMockStorage(mockResult);

		score = 80;
		mockResult = createMockResult(patientId, score, twoWeeksAgo);
		addResultToMockStorage(mockResult);
	}

	private AssessmentResult createMockResult(String patientId, int score, Date dateTaken) {
		PCLAssessmentResultGenerator generator = new PCLAssessmentResultGenerator();
		return generator.generateAssessmentResultFromScore(patientId, dateTaken, score);
	}

	@Override
	public AssessmentResult fetchAssessmentResult(PatientIdentifier patientIdentifier, String resultId) {
		AssessmentResult retrievedAssessmentResult = null;
		AssessmentResults resultsForPatientId = mockStorage.get(patientIdentifier.getUniqueId());
		for (AssessmentResult assessmentResult : resultsForPatientId) {
			if (assessmentResult.getUniqueId().equals(resultId)) {
				retrievedAssessmentResult = assessmentResult;
			}
		}

		return retrievedAssessmentResult;
	}

	@Override
	public AssessmentResults fetchResultsByAssessment(PatientIdentifier patientIdentifier, String assessmentId, DateFilter filter) {
		AssessmentResults resultsForPatient = new AssessmentResults();
		if (assessmentId.equals(AssessmentCode.ASSESSMENT_ID_PTSD)) {
			resultsForPatient = mockStorage.get(patientIdentifier.getUniqueId());
			resultsForPatient = DateFilterer.filterByDate(resultsForPatient, filter);
		} else {
			throw new RuntimeException("AssessmentId is expected to be ptsd");
		}
		return resultsForPatient;
	}

	@Override
	public AssessmentResult fetchMostRecentlyCompletedResult(String assessmentId, PatientIdentifier patientIdentifier) {
		throw new NotImplementedException();
	}

	@Override
	public AssessmentResult saveAssessmentResult(AssessmentResult assessmentResult) {
		throw new NotImplementedException();
	}

	public AssessmentResults fetchAssessmentDraftsByPatient(PatientIdentifier patientIdentifier) {
		throw new NotImplementedException();
	}

	private void addResultToMockStorage(AssessmentResult assessmentResult) {
		String patientId = assessmentResult.getPatientId();
		AssessmentResults existingAssessmentResults = mockStorage.get(patientId);
		if (existingAssessmentResults == null) {
			existingAssessmentResults = new AssessmentResults();
		}
		existingAssessmentResults.add(assessmentResult);
		mockStorage.put(patientId, existingAssessmentResults);
	}
}