package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresult;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResponses;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResult;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResultReport;
import com.agilex.healthcare.utility.ObjectSerializer;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name = AssessmentResultPo.TABLE_NAME)
@XStreamAlias("AssessmentResult")
public class AssessmentResultPo extends PersistenceObject implements Transformable<AssessmentResult> {

	private static final long serialVersionUID = 4866970597725551480L;
    public static final String TABLE_NAME = "ASSESSMENT_RESULT";

    private String uniqueTitle;
	private String version;
	private String authenticationStrategy;
	private String notes;
	private Date dateTaken;
	private int score;
	private String responses;
	private boolean inProgress;
	private String assessmentId;
	private String scoringAlgorithm;
	private String report;
	private int waitingPeriod;

    public AssessmentResultPo() {}

    public AssessmentResultPo(AssessmentResult dto) {
        setId(dto.getUniqueId());
        setAssessmentId(dto.getAssessmentId());
        setUniqueTitle(dto.getUniqueTitle());
        setVersion(dto.getVersion());
        setAuthenticationStrategy(dto.getAuthenticationStrategy());
        setUserId(dto.getPatientId());
        setNotes(dto.getNotes());
        setDateTaken(dto.getDateTaken());
        setScore(dto.getScore());
        setInProgress(dto.isInProgress());
        setAssessmentId(dto.getAssessmentId());
        setScoringAlgorithm(dto.getScoringAlgorithm());
        setWaitingPeriod(dto.getWaitingPeriod());

        if (dto.getAssessmentResultReport() != null)
            setReport(ObjectSerializer.serializeAsXml(dto.getAssessmentResultReport()));

        setResponses(ObjectSerializer.serializeAsXml(dto.getResponses()));
    }

	@Id
	@GeneratedValue(generator = "assessment_result_id_generator")
	@GenericGenerator(name = "assessment_result_id_generator", strategy = "uuid")
	@Column(name = "ASSESSMENT_RESULT_ID", nullable = false)
	public String getId() {
		return super.getId();
	}

	@Column(name = "PATIENT_ID")
	public String getUserId() {
		return super.getUserId();
	}

	@Column(name = "UNIQUE_TITLE")
	public String getUniqueTitle() {
		return uniqueTitle;
	}

	public void setUniqueTitle(String uniqueTitle) {
		this.uniqueTitle = uniqueTitle;
	}

	@Column(name = "VERSION")
	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	@Column(name = "AUTHENTICATION_STRATEGY")
	public String getAuthenticationStrategy() {
		return authenticationStrategy;
	}

	public void setAuthenticationStrategy(String authenticationStrategy) {
		this.authenticationStrategy = authenticationStrategy;
	}

	@Column(name = "NOTES")
	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}

	@Column(name = "DATE_TAKEN")
	public Date getDateTaken() {
		return dateTaken;
	}

	public void setDateTaken(Date dateTaken) {
		this.dateTaken = dateTaken;
	}

	@Column(name = "SCORE")
	public int getScore() {
		return score;
	}

	public void setScore(int score) {
		this.score = score;
	}

	@Column(name = "RESPONSES")
	public String getResponses() {
		return responses;
	}

	public void setResponses(String responses) {
		this.responses = responses;
	}

	@Column(name = "IN_PROGRESS")
	public boolean isInProgress() {
		return inProgress;
	}

	public void setInProgress(boolean inProgress) {
		this.inProgress = inProgress;
	}

	@Column(name = "ASSESSMENT_ID")
	public String getAssessmentId() {
		return assessmentId;
	}

	public void setAssessmentId(String assessmentId) {
		this.assessmentId = assessmentId;
	}

	@Column(name = "SCORING_ALGORITHM")
	public String getScoringAlgorithm() {
		return scoringAlgorithm;
	}

	public void setScoringAlgorithm(String scoringAlgorithm) {
		this.scoringAlgorithm = scoringAlgorithm;
	}

	@Column(name = "REPORT")
	public String getReport() {
		return report;
	}

	public void setReport(String report) {
		this.report = report;
	}

	@Column(name = "WAITING_PERIOD")
	public int getWaitingPeriod() {
		return waitingPeriod;
	}

	public void setWaitingPeriod(int waitingPeriod) {
		this.waitingPeriod = waitingPeriod;
	}

    @Override
    public AssessmentResult create() {
        AssessmentResult assessmentResult = new AssessmentResult();

        assessmentResult.setUniqueId(getId());
        assessmentResult.setUniqueTitle(getUniqueTitle());
        assessmentResult.setVersion(getVersion());
        assessmentResult.setAuthenticationStrategy(getAuthenticationStrategy());
        assessmentResult.setPatientId(getUserId());
        assessmentResult.setNotes(getNotes());
        assessmentResult.setDateTaken(getDateTaken());
        assessmentResult.setScore(getScore());
        assessmentResult.setInProgress(isInProgress());
        assessmentResult.setAssessmentId(getAssessmentId());
        assessmentResult.setScoringAlgorithm(getScoringAlgorithm());
        assessmentResult.setWaitingPeriod(getWaitingPeriod());

        if (getReport() != null)
            assessmentResult.setAssessmentResultReport(ObjectSerializer.deserializeFromXml(getReport(), AssessmentResultReport.class));

        AssessmentResponses responses = ObjectSerializer.deserializeFromXml(getResponses(), AssessmentResponses.class);
        assessmentResult.setResponses(responses);

        return assessmentResult;
    }
}
