package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresult;

import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults.AssessmentResultDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;

@Service
public class AssessmentResultDataLayerRepo implements AssessmentResultDataLayer {

	@Resource
	AssessmentResultDao assessmentResultDao;

	@Override
	public AssessmentResult fetchAssessmentResult(PatientIdentifier patientIdentifier, String resultId) {
        return assessmentResultDao.get(patientIdentifier, resultId);
	}

	@Override
	public AssessmentResults fetchResultsByAssessment(PatientIdentifier patientIdentifier, String assessmentId, DateFilter filter) {
        return assessmentResultDao.getByAssessment(patientIdentifier.getUniqueId(), assessmentId, filter);
	}

	@Override
	public AssessmentResult saveAssessmentResult(AssessmentResult assessmentResult) {
        return assessmentResultDao.save(assessmentResult);
	}

	@Override
	public AssessmentResults fetchAssessmentDraftsByPatient(PatientIdentifier patientIdentifier) {
        return assessmentResultDao.getDrafts(patientIdentifier.getUniqueId());
	}

	@Override
	public AssessmentResult fetchMostRecentlyCompletedResult(String assessmentId, PatientIdentifier patientIdentifier) {
        return assessmentResultDao.getComplete(patientIdentifier, assessmentId);
	}

    public void delete(AssessmentResult result) {
        assessmentResultDao.delete(result);
    }
}