package com.agilex.healthcare.mobilehealthplatform.datalayer.assessment;

import com.agilex.healthcare.mobilehealthplatform.datalayer.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.utility.ObjectSerializer;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

@Entity
@Table(name = "ASSESSMENT_QUESTIONS")
public class AssessmentQuestionPo extends PersistenceObject implements Transformable<AssessmentQuestion> {
    private static final long serialVersionUID = 3999505456827012466L;

    private int questionNumber;
    private String type;
    private String prompt;
    private String questionChoices;
    private String properties;
    private AssessmentPo assessment;

    public AssessmentQuestionPo() {}

    public AssessmentQuestionPo(AssessmentPo assessment, AssessmentQuestion question) {
        setAssessment(assessment);
        setPrompt(question.getPrompt());
        setQuestionNumber(question.getQuestionNumber());
        setType(question.getType());
        setId(question.getId());
        setProperties(ObjectSerializer.serializeAsXml(question.getQuestionProperties()));
        setQuestionChoices(ObjectSerializer.serializeAsXml(question.getQuestionChoices()));
    }

    @Id
    @GeneratedValue(generator="assessment_questions_id_generator")
    @GenericGenerator(name="assessment_questions_id_generator", strategy = "uuid")
    @Column(name="ID")
    public String getId() {
        return super.getId();
    }

    @Column(name="QUESTION_NUMBER")
    public int getQuestionNumber() {
        return questionNumber;
    }

    public void setQuestionNumber(int questionNumber) {
        this.questionNumber = questionNumber;
    }

    @Column(name="TYPE")
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Column(name="PROMPT")
    public String getPrompt() {
        return prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    @Column(name="QUESTION_CHOICES")
    public String getQuestionChoices() {
        return questionChoices;
    }

    public void setQuestionChoices(String questionChoices) {
        this.questionChoices = questionChoices;
    }

    @Column(name="PROPERTIES")
    public String getProperties() {
        return properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "ASSESSMENT_ID", nullable = false)
    public AssessmentPo getAssessment() {
        return assessment;
    }

    public void setAssessment(AssessmentPo assessment) {
        this.assessment = assessment;
    }

    @Override
    public AssessmentQuestion create() {
        AssessmentQuestion question = new AssessmentQuestion();

        question.setId(getId());
        question.setPrompt(getPrompt());
        question.setQuestionNumber(getQuestionNumber());
        question.setType(getType());
        question.setQuestionChoices(ObjectSerializer.deserializeFromXml(getQuestionChoices(), AssessmentQuestionChoices.class));
        question.setQuestionProperties(ObjectSerializer.deserializeFromXml(getProperties(), AssessmentProperties.class));

        return question;
    }
}
