package com.agilex.healthcare.mobilehealthplatform.datalayer.assessment;

import com.agilex.healthcare.mobilehealthplatform.datalayer.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.util.*;

@Entity
@Table(name = "ASSESSMENTS")
public class AssessmentPo extends PersistenceObject implements Transformable<Assessment> {
    private static final long serialVersionUID = 9119102907136765547L;

    private String uniqueTitle;
    private String version;
    private String authenticationStrategy;
    private boolean inHealthAssessment;
    private String notes;
    private String scoringAlgorithm;
    private boolean published;
    private int waitingPeriod;
    private List<AssessmentQuestionPo> questions;

    public AssessmentPo() {}

    public AssessmentPo(Assessment dto) {
        setId(dto.getId());
        setVersion(dto.getVersion());
        setAuthenticationStrategy(dto.getAuthenticationStrategy());
        setInHealthAssessment(dto.isInHealthAssessment());
        setNotes(dto.getNotes());
        setScoringAlgorithm(dto.getScoringAlgorithm());
        setPublished(dto.getPublish());
        setWaitingPeriod(dto.getWaitingPeriod());
        setUniqueTitle(dto.getUniqueTitle());

        addQuestions(dto);
    }

    private void addQuestions(Assessment dto) {
        if (dto.getQuestions() == null)
            return;

        questions = new ArrayList<AssessmentQuestionPo>();

        for (AssessmentQuestion question : dto.getQuestions()) {
            questions.add(new AssessmentQuestionPo(this, question));
        }
    }

    @Id
    @GeneratedValue(generator = "assessments_id_generator")
    @GenericGenerator(name = "assessments_id_generator", strategy = "uuid")
    @Column(name = "ID")
    public String getId() {
        return super.getId();
    }

    @Column(name = "UNIQUE_TITLE")
    public String getUniqueTitle() {
        return uniqueTitle;
    }

    public void setUniqueTitle(String uniqueTitle) {
        this.uniqueTitle = uniqueTitle;
    }

    @Column(name = "VERSION")
    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Column(name = "AUTHENTICATION_STRATEGY")
    public String getAuthenticationStrategy() {
        return authenticationStrategy;
    }

    public void setAuthenticationStrategy(String authenticationStrategy) {
        this.authenticationStrategy = authenticationStrategy;
    }

    @Column(name = "IN_HEALTH_ASSESSMENT")
    public boolean getInHealthAssessment() {
        return inHealthAssessment;
    }

    public void setInHealthAssessment(boolean inHealthAssessment) {
        this.inHealthAssessment = inHealthAssessment;
    }

    @Column(name = "NOTES")
    public String getNotes() {
        return notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Column(name = "SCORING_ALGORITHM")
    public String getScoringAlgorithm() {
        return scoringAlgorithm;
    }

    public void setScoringAlgorithm(String scoringAlgorithm) {
        this.scoringAlgorithm = scoringAlgorithm;
    }

    @Column(name = "PUBLISHED")
    public boolean getPublished() {
        return published;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    @Column(name = "WAITING_PERIOD")
    public int getWaitingPeriod() {
        return waitingPeriod;
    }

    public void setWaitingPeriod(int waitingPeriod) {
        this.waitingPeriod = waitingPeriod;
    }

    @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "assessment")
    public List<AssessmentQuestionPo> getQuestions() {
        return questions;
    }

    public void setQuestions(List<AssessmentQuestionPo> questions) {
        this.questions = questions;
    }

    @Override
    public Assessment create() {
        Assessment assessment = new Assessment();

        assessment.setId(getId());
        assessment.setNotes(getNotes());
        assessment.setAuthenticationStrategy(getAuthenticationStrategy());
        assessment.setInHealthAssessment(getInHealthAssessment());
        assessment.setPublish(getPublished());
        assessment.setScoringAlgorithm(getScoringAlgorithm());
        assessment.setUniqueTitle(getUniqueTitle());
        assessment.setWaitingPeriod(getWaitingPeriod());
        assessment.setVersion(getVersion());

        assessment.setQuestions(createQuestionList());

        return assessment;
    }

    private AssessmentQuestions createQuestionList() {
        if (questions == null)
            return null;

        List<AssessmentQuestion> questionList = new ArrayList<AssessmentQuestion>();

        for (AssessmentQuestionPo question : questions) {
            AssessmentQuestion q = question.create();

            questionList.add(q);
        }

        AssessmentQuestions assessmentQuestions = new AssessmentQuestions();
        assessmentQuestions.addAll(questionList);

        return assessmentQuestions;
    }
}
