package com.agilex.healthcare.mobilehealthplatform.datalayer.assessment;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class AssessmentDataLayerRepo implements AssessmentDataLayer {

    @Resource
    AssessmentDao assessmentDao;

    @Override
    public Assessments fetchActiveAssessments() {
        return assessmentDao.getActive();
    }

    @Override
    public Assessment fetchAssessment(String assessmentId) {
        return assessmentDao.get(assessmentId);
    }

    @Override
    public AssessmentQuestion fetchQuestion(String assessmentId, String questionId) {
        return assessmentDao.getAssessmentQuestion(questionId);
    }

    @Override
    public Assessments fetchAssessmentsForHealthAssessment() {
        return assessmentDao.getHealthAssessments();
    }

    @Override
    public Assessment saveAssessment(Assessment assessment) {
        return assessmentDao.save(assessment);
    }

    @Override
    public void deleteAssessment(Assessment assessment) {
        assessmentDao.delete(assessment);
    }
}
