package com.agilex.healthcare.mobilehealthplatform.datalayer.assessment;

import com.agilex.healthcare.mobilehealthplatform.datalayer.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.*;

import java.util.*;

@Repository
public class AssessmentDao extends AbstractDao {
    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(AssessmentDataLayerRepo.class);

    private static final String ACTIVE_ASSESSMENTS = "from AssessmentPo where published = true";
    private static final String HEALTH_ASSESSMENTS = "from AssessmentPo where inHealthAssessment = true";
    private static final String ASSESSMENT_WHERE_ID = "from AssessmentPo where id = :id";
    private static final String ASSESSMENT_QUESTION_WHERE_ID = "from AssessmentQuestionPo where id = :id";

    public Assessments getActive() {
        if (logger.isDebugEnabled())
            logger.debug("Retrieving active assessments");

        return getByQuery(ACTIVE_ASSESSMENTS);
    }

    public Assessments getHealthAssessments() {
        if (logger.isDebugEnabled())
            logger.debug("Retrieving health assessments");

        return getByQuery(HEALTH_ASSESSMENTS);
    }

    private Assessments getByQuery(String query) {
        SimpleEntityManager<AssessmentPo> simpleEntityManager = new SimpleEntityManager<AssessmentPo>(query, entityManager);
        List<AssessmentPo> results = simpleEntityManager.get(AssessmentPo.class);

        List<Transformable<? extends DomainTransferObject>> transformableList = createTransformableList(results);

        Assessments assessments = new Assessments();
        Mapper.add(transformableList, assessments);

        return assessments;
    }

    private List<Transformable<? extends DomainTransferObject>> createTransformableList(List<AssessmentPo> results) {
        List<Transformable<? extends DomainTransferObject>> transformableList = new ArrayList<Transformable<? extends DomainTransferObject>>();
        transformableList.addAll(results);

        return transformableList;
    }

    public Assessment get(String assessmentId) {
        if (logger.isDebugEnabled())
            logger.debug("Retrieving assessment");

        SimpleEntityManager<AssessmentPo> simpleEntityManager = new SimpleEntityManager<AssessmentPo>(ASSESSMENT_WHERE_ID, entityManager);
        List<AssessmentPo> results = simpleEntityManager.get(assessmentId, AssessmentPo.class);

        if (results.size() == 0)
            return null;

        if (results.size() > 1 && logger.isDebugEnabled())
            logger.debug("Found more than one assessment for an id ");

        return results.get(0).create();
    }

    public AssessmentQuestion getAssessmentQuestion(String questionId) {
        if (logger.isDebugEnabled()) logger.debug("Retrieving assessment question for an id");

        SimpleEntityManager<AssessmentQuestionPo> simpleEntityManager = new SimpleEntityManager<AssessmentQuestionPo>(ASSESSMENT_QUESTION_WHERE_ID, entityManager);
        List<AssessmentQuestionPo> results = simpleEntityManager.get(questionId, AssessmentQuestionPo.class);

        if (results.size() == 0)
            return null;

        if (results.size() > 1 && logger.isDebugEnabled())
            logger.debug("Found more than one assessment question for an id ");

        return results.get(0).create();
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public Assessment save(Assessment assessment) {
        if (logger.isDebugEnabled()) logger.debug("Saving Assessment");

        SimpleEntityManager<AssessmentPo> simpleEntityManager = new SimpleEntityManager<AssessmentPo>(entityManager);
        AssessmentPo po = simpleEntityManager.save(new AssessmentPo(assessment));

        if (logger.isDebugEnabled())
            logger.debug("Saved Assessment");

        return po.create();
    }

    @Transactional(propagation = Propagation.REQUIRED)
    public void delete(Assessment assessment) {
        if (logger.isDebugEnabled())
            logger.debug("Deleting Assessment");

        PersistenceObject po = entityManager.find(AssessmentPo.class, assessment.getId());
        entityManager.remove(po);
    }
}
