package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.agilex.healthcare.mobilehealthplatform.domain.DetailCode;
import com.thoughtworks.xstream.annotations.XStreamAlias;

@Entity
@Table(name = "DETAIL_CODE")
@XStreamAlias("DetailCode")
public class DetailCodePo extends PersistenceObject implements Transformable<DetailCode> {
	
	private static final long serialVersionUID = -4538293786391954349L;
	
	private String code;
	private String providerMessage;
	private String veteranMessage;

	public DetailCodePo() {
	}
	
	public DetailCodePo(DetailCode dto) {
		setCode(dto.getCode());
		setProviderMessage(dto.getProviderMessage());
		setVeteranMessage(dto.getVeteranMessage());
	}
	
	@Id
	@Column(name = "DETAIL_CODE_ID")
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	@Column(name = "PROVIDER_MESSAGE")
	public String getProviderMessage() {
		return providerMessage;
	}

	public void setProviderMessage(String providerMessage) {
		this.providerMessage = providerMessage;
	}

	@Column(name = "VETERAN_MESSAGE")
	public String getVeteranMessage() {
		return veteranMessage;
	}

	public void setVeteranMessage(String veteranMessage) {
		this.veteranMessage = veteranMessage;
	}

	@Override
	public DetailCode create() {
		DetailCode dto = new DetailCode();
		dto.setCode(getCode());
		dto.setProviderMessage(getProviderMessage());
		dto.setVeteranMessage(getVeteranMessage());
		
		return dto;
	}
}
