package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import java.util.Set;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.domain.DetailCode;

@Service
public class DetailCodeDataLayerRepo implements DetailCodeDataLayer{

	@Resource
	private AppointmentRequestDao dao;

	@Override
	public Set<DetailCode> fetchDetailCodes() {
		return dao.getDetailCodes();
	}

	@Override
	public DetailCode fetchDetailCodeByCode(String code) {
		return dao.getDetailCodeByCode(code);
	}
}
