package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestMessage;
import com.thoughtworks.xstream.annotations.XStreamAlias;

@Entity
@Table(name = AppointmentRequestMessagePo.TABLE_NAME)
@XStreamAlias("AppointmentRequestMessage")
public class AppointmentRequestMessagePo extends PersistenceObject implements Transformable<AppointmentRequestMessage> {
	private static final long serialVersionUID = 200834375889390334L;

    public static final String TABLE_NAME = "APPOINTMENT_REQUEST_MESSAGE";

	//<column name="APPOINTMENT_REQUEST_ID" type="varchar(32)"/>
	private String  appointmentRequestId;

	//<column name="SENDER_ID" type="varchar(255)"/>
	private String senderId;

	//<column name="MESSAGE_TEXT" type="varchar(255)"/>
	private String messageText;

	//<column name="MESSAGE_DATE_TIME" type="datetime"/>
	private Date messageDateTime;

	public AppointmentRequestMessagePo() {
	}
	
	public AppointmentRequestMessagePo(AppointmentRequestMessage dto) {
		setAppointmentRequestId(dto.getAppointmentRequestId());
		setMessageDateTime(dto.getMessageDateTime());
		setSenderId(dto.getSenderId());
		setMessageText(dto.getMessageText());
	}
	
	@Id
	@GeneratedValue(generator="appointment_request_message_id_generator")
	@GenericGenerator(name="appointment_request_message_id_generator", strategy = "uuid")
	@Column(name = "ID")
	public String getId() {
		return super.getId();
	}

	public void setId(String id) {
		super.setId(id);
	}

	@Column(name = "APPOINTMENT_REQUEST_ID")
	public String getAppointmentRequestId() {
		return appointmentRequestId;
	}

	public void setAppointmentRequestId(String appointmentRequestId) {
		this.appointmentRequestId = appointmentRequestId;
	}

	@Column(name = "SENDER_ID")
	public String getSenderId() {
		return senderId;
	}

	public void setSenderId(String senderId) {
		this.senderId = senderId;
	}

	@Column(name = "MESSAGE_TEXT")
	public String getMessageText() {
		return messageText;
	}

	public void setMessageText(String messageText) {
		this.messageText = messageText;
	}

	@Column(name = "MESSAGE_DATE_TIME")
	public Date getMessageDateTime() {
		return messageDateTime;
	}

	public void setMessageDateTime(Date messageDateTime) {
		this.messageDateTime = messageDateTime;
	}

	@Override
	public AppointmentRequestMessage create() {
		AppointmentRequestMessage dto = new AppointmentRequestMessage();

		dto.setAppointmentRequestId(getAppointmentRequestId());
		dto.setMessageDateTime(getMessageDateTime());
		dto.setSenderId(getSenderId());
		dto.setMessageText(getMessageText());
        dto.getDataIdentifier().setUniqueId(getId());
				
		return dto;
	}

}
