package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestInProcess;
import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;

@Entity
@Table(name = "APPT_REQ_INPROCESS")
public class AppointmentRequestInProcessPo extends PersistenceObject implements Transformable<AppointmentRequestInProcess> {

	private static final long serialVersionUID = 8268305988136237418L;
	
	private String appointmentRequestId;
	private String userId;
	private String firstName;
	private String lastName;
	
	public AppointmentRequestInProcessPo(){
		
	}

	public AppointmentRequestInProcessPo(AppointmentRequestInProcess dto) {
		this.appointmentRequestId = dto.getAppointmentRequestId();
		this.userId = dto.getUserId();
		this.firstName = dto.getFirstName();
		this.lastName = dto.getLastName();
	}

	@Id
    @Column(name="APPT_REQ_ID", nullable=false)
	public String getAppointmentRequestId() {
		return appointmentRequestId;
	}

    @Column(name="USER_ID", nullable=false)
	public String getUserId() {
		return userId;
	}


	public void setUserId(String userId) {
		this.userId = userId;
	}

    @Column(name="FIRST_NAME", nullable=false)
	public String getFirstName() {
		return firstName;
	}


	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

    @Column(name="LAST_NAME", nullable=false)
	public String getLastName() {
		return lastName;
	}


	public void setLastName(String lastName) {
		this.lastName = lastName;
	}


	@Override
	public AppointmentRequestInProcess create() {
		AppointmentRequestInProcess dto = new AppointmentRequestInProcess();
		dto.setAppointmentRequestId(appointmentRequestId);
		dto.setUserId(userId);
		dto.setFirstName(firstName);
		dto.setLastName(lastName);
		
		return dto;
	}

	public void setAppointmentRequestId(String appointmentRequestId) {
		this.appointmentRequestId = appointmentRequestId;
	}
}
