package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestInProcess;

@Service
public class AppointmentRequestInProcessDataLayerRepo implements AppointmentRequestInProcessDataLayer{

	@Resource
	private AppointmentRequestInProcessDao dao;

	@Override
	public AppointmentRequestInProcess fetchAppointmentRequestInProcessByAppointmentRequestId(String appointmentRequestId) {
		return dao.get(appointmentRequestId);
	}

	@Override
    public AppointmentRequestInProcess saveAppointmentRequestInProcess(AppointmentRequestInProcess appointmentRequestInProcess) {
		return dao.save(appointmentRequestInProcess);
	}

	@Override
	public void deleteAppointmentRequestInProcessByUserId(String userId) {
		dao.deleteByUserId(userId);
	}

	@Override
	public void deleteAppointmentRequestInProcessById(String appointmentRequestId) {
		dao.deleteById(appointmentRequestId);
	}

}
