package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestDetailCode;
import com.thoughtworks.xstream.annotations.XStreamAlias;

@Entity
@Table(name = "AR_DETAIL_CODE")
@XStreamAlias("AppointmentRequestDetailCode")
public class AppointmentRequestDetailCodePo extends PersistenceObject implements Transformable<AppointmentRequestDetailCode> {

	private static final long serialVersionUID = 4349985670679093473L;
	
	private String appointmentRequestDetailCodeId;
	private Date createdDate;
	
	private AppointmentRequestPo appointmentRequest;
	private DetailCodePo detailCode;

	public AppointmentRequestDetailCodePo() {
	}
	
	public AppointmentRequestDetailCodePo(AppointmentRequestDetailCode dto) {
		setAppointmentRequestDetailCodeId(dto.getAppointmentRequestDetailCodeId());
		setCreatedDate(dto.getCreatedDate());
		setDetailCode(new DetailCodePo(dto.getDetailCode()));
		setUserId(dto.getUserId());
	}

	@Id
	@GeneratedValue(generator="ardc_id_generator")
	@GenericGenerator(name="ardc_id_generator", strategy = "uuid")
	@Column(name = "AR_DETAIL_CODE_ID")
	public String getAppointmentRequestDetailCodeId() {
		return appointmentRequestDetailCodeId;
	}

	public void setAppointmentRequestDetailCodeId(String appointmentRequestDetailCodeId) {
		this.appointmentRequestDetailCodeId = appointmentRequestDetailCodeId;
	}

	@ManyToOne(targetEntity = AppointmentRequestPo.class, optional = false)
	@JoinColumn(name = "APPOINTMENT_REQUEST_ID")
	public AppointmentRequestPo getAppointmentRequest() {
		return appointmentRequest;
	}

	public void setAppointmentRequest(AppointmentRequestPo appointmentRequest) {
		this.appointmentRequest = appointmentRequest;
	}

	@ManyToOne(targetEntity = DetailCodePo.class, optional = false, fetch = FetchType.EAGER)
	@JoinColumn(name="DETAIL_CODE_ID")
	public DetailCodePo getDetailCode() {
		return detailCode;
	}

	public void setDetailCode(DetailCodePo detailCode) {
		this.detailCode = detailCode;
	}

	@Column(name = "CREATED_DATE")
	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	@Column(name = "USER_ID")
	@Override
	public String getUserId() {
		return super.getUserId();
	}

	@Override
	public AppointmentRequestDetailCode create() {
		AppointmentRequestDetailCode dto = new AppointmentRequestDetailCode();
		
		dto.setAppointmentRequestDetailCodeId(getAppointmentRequestDetailCodeId());
		dto.setCreatedDate(getCreatedDate());
		dto.setDetailCode(getDetailCode().create());
		dto.setUserId(getUserId());
		
		return dto;
	}
}
