package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequest;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestMessages;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequests;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;

@Service
public class AppointmentRequestDataLayerRepo implements AppointmentRequestDataLayer {
	
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(AppointmentRequestDataLayerRepo.class);

	@Resource
	private AppointmentRequestDao dao;

	@Override
	public AppointmentRequests fetchAppointmentRequestsByPatient(String patientId, DateFilter filter) {
		LOGGER.debug("Getting AppointmentRequest for patient");
		return dao.getActiveAppointmentRequests(patientId, filter);
	}

	public AppointmentRequest saveAppointmentRequest(AppointmentRequest appointmentRequest) {
		LOGGER.debug("Saving AppointmentRequest for patient");
		return dao.saveAppointmentRequest(appointmentRequest);
	}

	public void deleteAppointmentRequest(AppointmentRequest appointmentRequest) {
		LOGGER.debug("Deleting AppointmentRequest for patient");
		dao.deleteAppointmentRequest(appointmentRequest);
	}

	@Override
	public AppointmentRequest fetchAppointmentRequest(String patientId, String appointmentRequestId) {
		LOGGER.debug("Getting Filtered AppointmentRequests for patient");
		return dao.getActiveAppointmentRequest(patientId, appointmentRequestId);
	}

    @Override
    public AppointmentRequestMessages fetchAppointmentRequestMessages(String patientId, String appointmentRequestId) {
    	LOGGER.debug("Getting AppointmentRequestMessages for patient");
    	return dao.getAppointmentRequestMessagesByAppointmentRequestId(patientId, appointmentRequestId);
    }

    @Override
    public AppointmentRequestMessage saveAppointmentRequestMessage(String patientId, AppointmentRequestMessage appointmentRequestMessage, boolean isProvider) {
    	LOGGER.debug("Saving appointmentRequestMessage ");
		
		return dao.saveAppointmentRequestMessage(patientId, appointmentRequestMessage, isProvider);
    }

    @Override
	public AppointmentRequests fetchAppointmentRequests(AppointmentRequestFilter filter) {
		LOGGER.debug("Getting AppointmentRequest with using filter");
		return dao.getAppointmentRequests(filter);
	}

	@Override
	public AppointmentRequest updateMessageFlag(String patientId, String appointmentRequestId, boolean isProvider) {
		LOGGER.debug("Updating message flag for Appointment Request");
		return dao.updateAppointmentRequestMessageFlag(patientId, appointmentRequestId, isProvider);
	}

	@Override
	public AppointmentRequest markAppointmentRequestIsSeenByProvider(String patientId, String appointmentRequestId) {
		LOGGER.debug("Updating Provider_Seen_Appointment_Request flag for Appointment Request Id");
		return dao.updateProviderSeenAppointmentRequestFlag(patientId, appointmentRequestId);
	}
}
