package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentMetric;

@Service
public class AppointmentMetricsDataLayerRepo implements AppointmentMetricsDataLayer{

	@Resource
	private AppointmentMetricsDao dao;

	@Override
	public AppointmentMetric getMetric(String name) {
		return dao.getAppointmentMetric(name);
	}

	@Override
	public AppointmentMetric saveMetric(AppointmentMetric metric) {
		return dao.saveAppointmentMetric(metric);
	}

	@Override
	public void removeMetric(String name) {
		dao.removeAppointmentMetric(name);
	}
}
