package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.agilex.healthcare.mobilehealthplatform.datalayer.AbstractDao;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentMetric;

@Repository
public class AppointmentMetricsDao extends AbstractDao {
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(AppointmentMetricsDao.class);
	
	public AppointmentMetric getAppointmentMetric(String name) {
		AppointmentMetricPo po = this.entityManager.find(AppointmentMetricPo.class, name);
		
		return (po == null) ? null : po.create();
	}
	
	@Transactional(propagation = Propagation.REQUIRED)
	public AppointmentMetric saveAppointmentMetric(AppointmentMetric metric) {
		AppointmentMetricPo po =  this.entityManager.merge(new AppointmentMetricPo(metric));
		
		return (po == null) ? null : po.create();
	}
	
	@Transactional(propagation = Propagation.REQUIRED)
	public void removeAppointmentMetric(String name) {
		AppointmentMetric metricToRemove = getAppointmentMetric(name);
		this.entityManager.remove(new AppointmentMetricPo(metricToRemove));
	}
}
