package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentMetric;
import com.thoughtworks.xstream.annotations.XStreamAlias;

@Entity
@Table(name = "APPOINTMENT_METRICS")
@XStreamAlias("AppointmentMetric")
public class AppointmentMetricPo extends PersistenceObject implements Transformable<AppointmentMetric> {
	private static final long serialVersionUID = 8705978416581705866L;
	
	private String name;
	private int value;
	
	public AppointmentMetricPo() {
	}
	
	public AppointmentMetricPo(AppointmentMetric dto) {
		setName(dto.getName());
		setValue(dto.getValue());
	}
	
	@Id
	@Column(name = "NAME")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "VALUE")
	public int getValue() {
		return value;
	}

	public void setValue(int value) {
		this.value = value;
	}

	@Override
	public AppointmentMetric create() {
		AppointmentMetric dto = new AppointmentMetric();
		dto.setName(getName());
		dto.setValue(getValue());
		
		return dto;
	}
}
