package com.agilex.healthcare.mobilehealthplatform.datalayer;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.agilex.healthcare.mobilehealthplatform.domain.UserLastAccessedTime;

@Repository
public class UserLastAccessedTimeDataLayerRepo extends AbstractDao implements UserLastAccessedTimeDataLayer {
	
	@Override
	public UserLastAccessedTime fetchUserLastAccessedTime(String userId) {
		UserLastAccessedTimePo po =  this.entityManager.find(UserLastAccessedTimePo.class, userId);
		return toDto(po);
	}

	@Override
	@Transactional(propagation = Propagation.REQUIRED)
	public UserLastAccessedTime saveUserLastAccessedTime(UserLastAccessedTime dto) {
		
		//Save only if the last accessed time is greater than the previously saved value
		UserLastAccessedTimePo latestPo = toPo(dto);
		UserLastAccessedTimePo existingPo =  this.entityManager.find(UserLastAccessedTimePo.class, latestPo.getUserId());

		if(existingPo == null || existingPo.getLastAccessedTime().before(latestPo.getLastAccessedTime())){
			existingPo =  this.entityManager.merge(latestPo);
		}
		
		return toDto(existingPo);
	}

	private UserLastAccessedTimePo toPo(UserLastAccessedTime dto){
		UserLastAccessedTimePo po = new UserLastAccessedTimePo();
		po.setUserId(dto.getUserId());
		po.setLastAccessedTime(dto.getLastAccessedTime());
		
		return po;
	}

	private UserLastAccessedTime toDto(UserLastAccessedTimePo po){
		if(po == null){
			return null;
		}
		
		UserLastAccessedTime dto = new UserLastAccessedTime();
		dto.setUserId(po.getUserId());
		dto.setLastAccessedTime(po.getLastAccessedTime());
		
		return dto;
	}
}
