package com.agilex.healthcare.mobilehealthplatform.datalayer;

import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import javax.persistence.TypedQuery;
import java.util.Date;

public class JpaDateFilter implements JpaFilter {
    private final Date startDate;
    private final Date endDate;
    private final String dateField;

    public JpaDateFilter() {
        this(DateFilterFactory.createEmptyFilter(), null);
    }

    public JpaDateFilter(DateFilter dateFilter, String dateField) {
        this.startDate = dateFilter.getStartDate();
        this.endDate = dateFilter.getEndDate();

        this.dateField = dateField;
    }

    public String createFilterQueryStr(String baseQuery) {
        StringBuilder builder = new StringBuilder(baseQuery);

        if (startDate != null)
            builder.append(" and ").append(dateField).append(" >= :startDate ");

        if (endDate != null)
            builder.append(" and ").append(dateField).append(" <= :endDate ");
        
        builder.append(" order by ").append(dateField);
        
        return builder.toString();
    }

    public void addFilterParameters(TypedQuery<?> query) {
        if (startDate != null)
            query.setParameter("startDate", startDate);

        if (endDate != null)
            query.setParameter("endDate", endDate);
    }
}
