package com.agilex.healthcare.mobilehealthplatform.datalayer;

import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObjectCollection;
import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.utility.NullChecker;

//Use Mapper and Implement the Transformable interface in your PO class
@Deprecated
public abstract class AbstractMapper<T extends DomainTransferObject, Ts extends DomainTransferObjectCollection<T>, P extends PersistenceObject> {

	public abstract T toDto(P po);
	public abstract P toPo(T dto);
	
	public Ts toDtoCollection(List<P> ps, Ts ts) {
		if (NullChecker.isNotNullish(ps)) {
			for (P p : ps) {
				T t = toDto(p);
				ts.add(t);
			}
		}
		return ts;
	}
	
	public List<P> toPoCollection(Ts ts, List<P> ps) {
		if(NullChecker.isNotNullish(ts)) {
			for(T t : ts) {
				P p = toPo(t);
				ps.add(p);
			}
		}
		return ps;
	}

}
