package com.agilex.healthcare.mobilehealthplatform.repository.dbunit;

import java.io.InputStream;

import org.dbunit.DBTestCase;
import org.dbunit.IDatabaseTester;
import org.dbunit.JdbcDatabaseTester;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ReplacementDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.operation.DatabaseOperation;

public abstract class DBUnitTest extends DBTestCase {

	public DBUnitTest() {
		super();
	}
	
	@Override
	protected IDatabaseTester newDatabaseTester() throws Exception{
		return new JdbcDatabaseTester("org.hsqldb.jdbcDriver", "jdbc:hsqldb:mem:HADB", "sa", "");
	}
	
	protected IDataSet getDataSet() throws Exception {
		InputStream datasetStream = this.getClass().getClassLoader().getResourceAsStream("dataset.xml");
		ReplacementDataSet dataset = new ReplacementDataSet(new FlatXmlDataSetBuilder().build(datasetStream)); 
		dataset.addReplacementObject("[NULL]", null);
		return dataset;
	}
	
	@Override
	protected DatabaseOperation getSetUpOperation() throws Exception {
		return DatabaseOperation.REFRESH;
	}
	
	@Override
	protected DatabaseOperation getTearDownOperation() throws Exception {
		return DatabaseOperation.NONE;
	}
}
