package com.agilex.healthcare.mobilehealthplatform.repository.dao.paingoal;

import java.util.Date;
import java.util.UUID;

import javax.annotation.Resource;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.UserHistoryIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.paingoal.PainGoalDao;
import com.agilex.healthcare.mobilehealthplatform.domain.PainGoal;
import com.agilex.healthcare.mobilehealthplatform.domain.PainGoals;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.PainGoalStatus;

public class PainGoalDaoTest extends UserHistoryIntegrationRepo {

	@Resource
    PainGoalDao dao;
	
	String userId;
	PainGoal goal;
	Date dateCreated;
	
	@Before
	public void before() {
		userId = UUID.randomUUID().toString();
		dateCreated = new Date();
	}
	
	@Test
	public void testSaveOfCompleteGoal() {
		goal = createCompleteGoal();
		PainGoal savedGoal = dao.createOrUpdateNewPainGoal(goal);
		
		assertNotNull(savedGoal);
		assertNotNull(savedGoal.getUniqueId());



	}

	
	@Test
	public void testSaveOfActiveGoal() {
		goal = createActiveGoal();
		PainGoal savedGoal = dao.createOrUpdateNewPainGoal(goal);
		
		assertNotNull(savedGoal);
		assertNotNull(savedGoal.getUniqueId());
		assertNotNull(savedGoal.getGoalType());
		assertNotNull(savedGoal.getName());
		assertNotNull(savedGoal.getDetails());
		assertNotNull(savedGoal.getPatientId());
		assertEquals(PainGoalStatus.PainGoalStatusActive, savedGoal.getStatus());
		assertNotNull(savedGoal.getTargetDate());
		assertNotNull(savedGoal.getNextActionStep());
		
	}

	@Test
	public void testRetrieveGoals() {
		dao.createOrUpdateNewPainGoal(createCompleteGoal());
		dao.createOrUpdateNewPainGoal(createCompleteGoal());
		dao.createOrUpdateNewPainGoal(createCompleteGoal());
		
		PainGoals goals = new PainGoals();
		goals = dao.getPainGoals(userId);
		
		assertNotNull(goals);
		assertFalse(goals.size() == 0);
		assertNotNull(goals.get(0).getName());
		assertEquals(PainGoalStatus.PainGoalStatusComplete, goals.get(0).getStatus());
		assertNotNull(goals.get(0).getDetails());
		assertNotNull(goals.get(0).getNextActionStep());
		assertNotNull(goals.get(0).getTargetDate());
//		assertNotNull(goals.get(0).getPainGoalEntries().get(0).getComments());
//		assertNotNull(goals.get(0).getPainGoalEntries().get(0).getEntryDate());
		assertNotNull(goals.get(0).getPercentComplete());
		assertNotNull(goals.get(0).getUniqueId());


	}
	
	@Test
	public void testRetrieveOfSingleGoal() {
		dao.createOrUpdateNewPainGoal(createCompleteGoal());
		
		PainGoals goals = new PainGoals();
		goals = dao.getPainGoals(userId);
		
		assertTrue(goals.size() == 1);
		
		PainGoal expectedGoal = goals.get(0);
		PainGoal actualPainGoal = dao.getPainGoal(userId, expectedGoal.getDataIdentifier().getUniqueId());
		assertEquals(expectedGoal.getDataIdentifier().getUniqueId(), actualPainGoal.getDataIdentifier().getUniqueId());

	}

	
	@Test
	public void testUpdateOfActiveGoal() {
		String ExpectedDetails = "I want to run a marathon next month.";
		
		PainGoal savedGoal = dao.createOrUpdateNewPainGoal(createActiveGoal());
		savedGoal.setDetails(ExpectedDetails);
		savedGoal.setNextActionStep("Step 20");



		PainGoal updatedGoal = dao.createOrUpdateNewPainGoal(savedGoal);
		
		assertEquals(savedGoal.getUniqueId(), updatedGoal.getUniqueId());
		assertEquals(savedGoal.getName(), updatedGoal.getName());
		assertEquals(savedGoal.getDetails(), updatedGoal.getDetails());
		assertEquals(savedGoal.getNextActionStep(), updatedGoal.getNextActionStep());
	}
	
	
	@Test
	public void testSaveAndUpdateGoal() {
		goal = createCompleteGoal();
		PainGoal savedGoal = dao.createOrUpdateNewPainGoal(goal);
		
		assertNotNull(savedGoal);
		assertNotNull(savedGoal.getUniqueId());
//		assertNotNull(savedGoal.getPainGoalEntries());
//		assertTrue(savedGoal.getPainGoalEntries().size() > 1);
//		assertNotNull(savedGoal.getPainGoalEntries().get(0).getComments());
//		assertNotNull(savedGoal.getPainGoalEntries().get(1).getComments());
		
		
		savedGoal.setNextActionStep("Step 2");
		savedGoal.setTargetDate(DateHelper.getTomorrow());
		PainGoal updatedGoal = dao.createOrUpdateNewPainGoal(savedGoal);
		
		assertEquals(savedGoal.getUniqueId(), updatedGoal.getUniqueId());
		assertEquals(savedGoal.getName(), updatedGoal.getName());
		assertEquals(savedGoal.getNextActionStep(), updatedGoal.getNextActionStep());
		assertEquals(savedGoal.getTargetDate(), updatedGoal.getTargetDate());
	}
	
	private PainGoal createCompleteGoal() {
		
		PainGoal g = new PainGoal();
		
		g.setPatientId(userId);
		g.setName("Do 10 pullups");
		g.setStatus(PainGoalStatus.PainGoalStatusComplete);
		g.setDateStarted(DateHelper.parseDate("08/01/2012"));
		g.setPercentComplete("100");
		g.setGoalType("Veteran");
		g.setDetails("Train upper body strength.");
		g.setNextActionStep("Step 1");
		g.setTargetDate(DateHelper.parseDate("01/01/2015"));
		
		return g;
	}
	
private PainGoal createActiveGoal() {
		
		PainGoal g = new PainGoal();
		
		g.setPatientId(userId);
		g.setName("Run a marathon");
		g.setStatus(PainGoalStatus.PainGoalStatusActive);
		g.setDateStarted(DateHelper.parseDate("09/02/2012"));
		g.setPercentComplete("70");
		g.setGoalType("Veteran");
		g.setDetails("Run 26.2 miles");
		g.setNextActionStep("Step 1");
		g.setTargetDate(DateHelper.parseDate("01/01/2014"));
		
		return g;
	}
}
