package com.agilex.healthcare.mobilehealthplatform.repository.dao.pain;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import javax.annotation.Resource;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.UserHistoryIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.paindiary.PainDiaryEntryDao;
import com.agilex.healthcare.mobilehealthplatform.datalayer.paindiary.PainDiaryEntryPo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.paindiary.PainDiaryResponsePo;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryQuestionId;

public class PainDiarySecurityTest extends PainDiaryDaoTestBase {

	@Before
	public void setUp() {
		super.setUp();
	}
	
	@After
	public void tearDown(){
		super.tearDown();
	}

	@Test
	public void hiTest() {
		System.out.println("hi");
	}

	@Test
	public void testRetrieveEntryWithMismatchId() {
		String userId1 = UUID.randomUUID().toString();
		String userId2 = UUID.randomUUID().toString();
		PainDiaryEntry createdEntity1 = createAndSaveEntry(userId1);
		PainDiaryEntry createdEntity2 = createAndSaveEntry(userId2);
		
		PainDiaryEntry foundEntity;
		foundEntity = dao.getPainDiaryEntry(userId2, createdEntity2.getUniqueId());
		assertNotNull(foundEntity.getUniqueId());
		
		foundEntity = dao.getPainDiaryEntry(userId2, createdEntity1.getUniqueId());		
		assertNull(foundEntity.getUniqueId());
	}

	@Test
	public void testUpdateEntryWithMismatchId() {
		String userId = UUID.randomUUID().toString();
		PainDiaryEntry savedEntity = createAndSaveEntry(userId);
		
		String userIdAlt = UUID.randomUUID().toString();
		savedEntity.setPatientId(userIdAlt);
		PainDiaryEntry foundEntity = dao.updatePainDiaryEntry(savedEntity);		
		assertNull(foundEntity);
	}
	
	private PainDiaryEntry createAndSaveEntry(String userId) {
		PainDiaryEntry entry = createEntry(userId);
		PainDiaryEntry createdEntity = dao.createNewPainDiaryEntry(entry);
		assertEquals(entry.getPatientId(),userId);
		assertEquals(entry.getPatientId(),createdEntity.getPatientId());
		return createdEntity;
	}
}
