package com.agilex.healthcare.mobilehealthplatform.repository.dao.pain;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import javax.annotation.Resource;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.UserHistoryIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.paindiary.PainDiaryEntryDao;
import com.agilex.healthcare.mobilehealthplatform.datalayer.paindiary.PainDiaryEntryPo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.paindiary.PainDiaryResponsePo;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.PainDiaryQuestionId;

public class PainDiaryDaoTestBase extends UserHistoryIntegrationRepo {
	
	@Resource
	PainDiaryEntryDao dao;
	
	String userId;
	PainDiaryEntry entry;
	Date dateCreated;
	
	public void setUp() {
		userId = UUID.randomUUID().toString();
		dateCreated = new Date();
	}
	
	public void tearDown() {
		userId = UUID.randomUUID().toString();
		dateCreated = new Date();
	}
	
	@Test
	@Ignore
	public void test() {
		assertTrue(true);
	}

	protected PainDiaryEntry createEntry() {
		return createEntry(userId);
	}
	
	protected PainDiaryEntry createEntry(String userId) {
		PainDiaryEntryPo po = new PainDiaryEntryPo();
		
		po.setCompleted(true);
		po.setDateCreated(dateCreated);
		po.setUserId(userId);
		
		List<PainDiaryResponsePo> painResponses = new ArrayList<PainDiaryResponsePo>(); 
		
		PainDiaryResponsePo response = new PainDiaryResponsePo();
		response.setQuestionId(PainDiaryQuestionId.PAIN_TYPE);
		response.setResponse("pain type");
		response.setEntry(po);
		painResponses.add(response);
		
		response = new PainDiaryResponsePo();
		response.setQuestionId(PainDiaryQuestionId.MOOD_LEVEL);
		response.setResponse("mood level");
		response.setEntry(po);
		painResponses.add(response);
		
		response = new PainDiaryResponsePo();
		response.setQuestionId(PainDiaryQuestionId.TREATMENT);
		response.setResponse("pain treatment 1");
		response.setEntry(po);
		painResponses.add(response);

		response = new PainDiaryResponsePo();
		response.setQuestionId(PainDiaryQuestionId.TREATMENT);
		response.setResponse("pain treatment 2");
		response.setEntry(po);
		painResponses.add(response);
		
		po.setPainResponses(painResponses);
		
		
		return po.create();
		
	}
}
