package com.agilex.healthcare.mobilehealthplatform.repository.dao.pain;

import java.util.*;
import javax.annotation.Resource;

import com.agilex.healthcare.mobilehealthplatform.datalayer.UserHistoryIntegrationRepo;
import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.paindiary.*;
import com.agilex.healthcare.utility.NullChecker;

public class PainDiaryDaoTest extends PainDiaryDaoTestBase {

	
	@Before
	public void setUp() {
		super.setUp();
	}
	
	@After
	public void tearDown(){
		super.tearDown();
	}

	@Test
	public void testSaveOfEntry() {
		entry = createEntry();
		String expectedPainType = entry.getPainQuestionValues().getPainType();
		int expectedTreatmentSize = entry.getPainQuestionValues().getTreatment().size();
		
		PainDiaryEntry savedEntry = new PainDiaryEntry();
		
		savedEntry = dao.createNewPainDiaryEntry(entry);
		
		assertNotNull(savedEntry);
		String uniqueId = savedEntry.getUniqueId();
		assertNotNull(uniqueId);
		assertTrue(uniqueId.length() != 0);
		
		assertTrue(expectedPainType.equalsIgnoreCase(savedEntry.getPainQuestionValues().getPainType()));
		assertNotNull(savedEntry.getPainQuestionValues().getTreatment());

		assertTrue("got " + savedEntry.getPainQuestionValues().getTreatment().size() + "wanted " + expectedTreatmentSize, savedEntry.getPainQuestionValues().getTreatment().size() == expectedTreatmentSize);
		assertTrue(NullChecker.isNotNullish(savedEntry.getPainQuestionValues().getTreatment().get(0)));
		
	}

	@Test
	public void testRetrieveEntries() {
		dao.createNewPainDiaryEntry(createEntry());
		dao.createNewPainDiaryEntry(createEntry());
		dao.createNewPainDiaryEntry(createEntry());
		
		PainDiaryEntries entries = new PainDiaryEntries();
		entries = dao.getPainDiaryEntries(userId);
		
		assertNotNull(entries);
		assertFalse(entries.size() == 0);
		assertNotNull(entries.get(0).getPainQuestionValues());
		assertNotNull(entries.get(0).getPainQuestionValues().getPainType());
		assertTrue("pain type".equalsIgnoreCase(entries.get(0).getPainQuestionValues().getPainType()));

		assertNotNull(entries.get(0).getPainQuestionValues().getMoodLevel());
		assertTrue(entries.get(0).getPainQuestionValues().getMoodLevel().equalsIgnoreCase("mood level"));
	}
	
	@Test
	public void testUpdateEntry() {
		
		String ExpectedPainType = "new pain type response";
		entry = createEntry();
		PainDiaryEntry savedEntry = new PainDiaryEntry();
		
		
		
		savedEntry = dao.createNewPainDiaryEntry(entry);

		int numEntriesBeforeUpdate = dao.getPainDiaryEntries(userId).size();
		savedEntry.getPainQuestionValues().setAmountRefreshedAfterSleep("sleep refreshed response");
		savedEntry.getPainQuestionValues().setPainType(ExpectedPainType);
		
		List<String> treatments = new ArrayList<String>();
		treatments.add("pain treatment 1");
		treatments.add("pain treatment 2");
		treatments.add("pain treatment 3");
		savedEntry.getPainQuestionValues().setTreatment(treatments);
		int expectedNumberOfTreatments = savedEntry.getPainQuestionValues().getTreatment().size();
		
		PainDiaryEntry updatedEntry = new PainDiaryEntry();
		updatedEntry = dao.updatePainDiaryEntry(savedEntry);
		
		assertNotNull(updatedEntry);
		
		assertTrue(dao.getPainDiaryEntries(userId).size() == numEntriesBeforeUpdate);
		assertTrue(ExpectedPainType.equalsIgnoreCase(updatedEntry.getPainQuestionValues().getPainType()));
		assertTrue(updatedEntry.getPainQuestionValues().getTreatment().size() == expectedNumberOfTreatments);
		
		assertTrue(updatedEntry.getPainQuestionValues().getTreatment().containsAll(treatments));
	}
}
