package com.agilex.healthcare.mobilehealthplatform.repository.dao.notification;

import java.util.List;
import java.util.UUID;

import javax.annotation.Resource;
import javax.ws.rs.WebApplicationException;

import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.NotificationDao;
import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.NotificationPo;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.utility.DateHelper;

public class NotificationDaoTestBase extends SpringBasedIntegrationRepo {

	@Resource
    NotificationDao dao;

	protected String userId1;
	protected String userId2;
	protected NotificationPo notification1;
	protected NotificationPo notification2;
	protected DateFilter emptyFilter;

	public void setUp(){
		userId1 = "PATID26";
		userId2 = UUID.randomUUID().toString();
	
		notification1 = createAndSaveBasicNotification(userId1, "1/1/2012", "Test Notification Body");
		notification2 = createAndSaveBasicNotification(userId2, "10/5/2011", "Test Notification Body");
		
		emptyFilter = DateFilterFactory.createEmptyFilter();
	}
	
	public void tearDown(){
		dao.deleteNotification(notification1);
		dao.deleteNotification(notification2);
	}
	
	@Test
	@Ignore
	public void test() {
		assertTrue(true);
	}
	
	public NotificationPo createAndSaveBasicNotification(String userId, String dateString, String body) {
		NotificationPo notification = createBasicNotification(userId, dateString, body);
		NotificationPo savedNotification = dao.saveNotification(notification);

		return savedNotification;
	}

	public NotificationPo createBasicNotification(String userId, String dateString, String body) {
		NotificationPo notification = new NotificationPo();
		notification.setDate(DateHelper.parseDate(dateString));
		notification.setUserId(userId);
		notification.setActiveFlag(true);
		notification.setBody(body);
		
		return notification;
	}

	protected boolean areAllNotificationsActive(List<NotificationPo> notifications) {
		boolean result = true;
		for (NotificationPo notification : notifications) {
			if (notification.isActiveFlag() == false) {
				result = false;
				break;
			}
		}
		return result;
	}

	protected void verifyActive(NotificationPo po, String msg) {
		try {
			// this throws an WebApplicationException if can't be found
			NotificationPo saved = dao.getActiveNotification(po.getUserId(), po.getId());
			assertTrue(msg,saved.isActiveFlag());
		} catch(WebApplicationException wae) {
			fail(msg);
			return;
		}
	}

}
