package com.agilex.healthcare.mobilehealthplatform.repository.dao.notification;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.NotificationPo;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.utility.DateHelper;


public class NotificationDaoTest extends NotificationDaoTestBase {
	
	private static final int MaxNumberOfReturnedNotifications = 50;
	static final long MILLISECONDS_IN_A_DAY = 1000*60*60*24;  
	
	@Before
	public void setUp() {
		super.setUp();
	}
	
	@After
	public void tearDown(){
		super.tearDown();
	}

	@Test
	public void verifyOnlyYourOwn() {
		NotificationPo notification = dao.getActiveNotification(userId1, notification1.getId());
		assertNotNull(notification);
		try {
			dao.getActiveNotification(userId2, notification1.getId());
		} catch(WebApplicationException wae) {
			assertTrue(true);
			return;
		}
		fail();
	}
	
	@Test
	public void getActiveNotifications() {
		List<NotificationPo> notifications = dao.getActiveNotifications(userId1, emptyFilter);
		assertNotNull(notifications);
		assertTrue(notifications.size() > 0);
		assertTrue(areAllNotificationsActive(notifications));
	}
	
	@Test
	public void getPrestagedNotifications() {
		List<NotificationPo> notifications = dao.getActiveNotifications(userId1, emptyFilter);

		assertTrue(notifications.size() > 0);
		assertTrue(areAllNotificationsActive(notifications));
		
		NotificationPo retrievedNotification = notifications.get(0);
		NotificationPo specificNotification = dao.getActiveNotification(userId1, retrievedNotification.getId());
		assertNotNull(specificNotification);
		
		assertEquals(retrievedNotification.getUserId(), specificNotification.getUserId());
		assertEquals(retrievedNotification.getId(), specificNotification.getId());
		assertEquals(retrievedNotification.getDate(), specificNotification.getDate());
		assertEquals(retrievedNotification.getBody(), specificNotification.getBody());
	}
	
	@Test
	public void verifySaveOfNotification() {
		assertNotNull(notification1);
		assertNotNull(notification2);
	}

	@Test
	public void verifyDeleteOfNotification() {
		String userId = UUID.randomUUID().toString();
		NotificationPo notification = createAndSaveBasicNotification(userId, "9/10/2012", "Test Notification Body for Delete");
		
		dao.deleteNotification(notification);
		
		boolean testResult = false;
		try {
			dao.getActiveNotification(userId, notification.getId());
		} catch (WebApplicationException e) {
			if (e.getResponse().getStatus() == Status.NOT_FOUND.getStatusCode()) {
				testResult = true;
			}
		}
		assertTrue(testResult);
	}
	
	@Test
	public void verifyReturnOfMaxNumber() {
		String userId = UUID.randomUUID().toString();
		
		for (int i=0; i<100; i++) {
			createAndSaveBasicNotification(userId, "1/1/2012", "Test Notification Body 3");			
		}
		
		
		List<NotificationPo> retrievedNotifications = dao.getActiveNotifications(userId, emptyFilter);
		assertEquals(retrievedNotifications.size(), MaxNumberOfReturnedNotifications);
		
		for (NotificationPo notification : retrievedNotifications) {
			dao.deleteNotification(notification);
		}

	}
	
	@Test
	public void verifyTodaysNotificationsReturned() {
		String userId = UUID.randomUUID().toString();
		
		Format formatter = new SimpleDateFormat("MM/dd/yyyy");
		
		Date todaysDate = DateHelper.getToday();
		Date yesterdaysDate = DateHelper.getYesterday();

		String todayString = formatter.format(todaysDate);
		String yesterdayString = formatter.format(yesterdaysDate);

		List<NotificationPo> notifications = new ArrayList<NotificationPo>();
		NotificationPo notification = new NotificationPo();
		
		notification = createAndSaveBasicNotification(userId, todayString, "Test Notification Body 4");	
		notifications.add(notification);
		notification = createAndSaveBasicNotification(userId, todayString, "Test Notification Body 5");			
		notifications.add(notification);
		notification = createAndSaveBasicNotification(userId, todayString, "Test Notification Body 6");			
		notifications.add(notification);
		
		notification = createAndSaveBasicNotification(userId, yesterdayString, "Test Notification Body 7");			
		notifications.add(notification);
		notification = createAndSaveBasicNotification(userId, yesterdayString, "Test Notification Body 8");			
		notifications.add(notification);
		
		DateFilter todayFilter = DateFilterFactory.createFilterFromToday();
		List<NotificationPo> retrievedNotifications = dao.getActiveNotifications(userId, todayFilter);
		assertEquals(3, retrievedNotifications.size());
		
		for (NotificationPo theNotification : notifications) {
			dao.deleteNotification(theNotification);
		}
	}
	
	@Test
	public void verifyReverseChronologicalOrder() {
		String userId = UUID.randomUUID().toString();
		
		NotificationPo notificationOld = createAndSaveBasicNotification(userId, "1/1/2012", "Test Notification Body Old");
		NotificationPo notificationNew = createAndSaveBasicNotification(userId, "1/15/2012", "Test Notification Body New");
		
		List<NotificationPo> retrievedNotifications = dao.getActiveNotifications(userId, emptyFilter);
		assertEquals(notificationNew.getBody(), retrievedNotifications.get(0).getBody());
		assertEquals(notificationOld.getBody(), retrievedNotifications.get(1).getBody());
		
		dao.deleteNotification(notificationNew);
		dao.deleteNotification(notificationOld);
	}
}
