package com.agilex.healthcare.mobilehealthplatform.repository.dao.notification;

import java.util.UUID;

import javax.annotation.Resource;
import javax.ws.rs.WebApplicationException;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.NotificationDao;
import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.NotificationPo;
import com.agilex.healthcare.utility.DateHelper;

public class NotificationDaoSecurityTest extends NotificationDaoTestBase {
	
	@Before
	public void setUp() {
		super.setUp();
	}
	
	@After
	public void tearDown(){
		super.tearDown();
	}

	@Test
	public void verifyDeleteOnlyYourOwn() {		
		notification1.setUserId(userId2);
		dao.deleteNotification(notification1);
		notification1.setUserId(userId1);
		verifyActive(notification1,"should not be able to delete anothers notification");
	}

	@Test
	public void verifyUpdateOnlyYourOwn() {		
		notification1.setUserId(userId2);
		notification1.setBody("new body");
		assertNull(dao.updateNotification(notification1));
	}

	@Test
	public void verifySaveExistingOnlyYourOwn() {		
		notification1.setUserId(userId2);
		notification1.setBody("new body");
		assertNull(dao.saveNotification(notification1));
		dao.deleteNotification(notification1);
	}
	
	public NotificationPo createAndSaveBasicNotification(String userId, String dateString, String body) {
		NotificationPo notification = createBasicNotification(userId, dateString, body);
		NotificationPo savedNotification = dao.saveNotification(notification);

		return savedNotification;
	}

	public NotificationPo createBasicNotification(String userId, String dateString, String body) {
		NotificationPo notification = new NotificationPo();
		notification.setDate(DateHelper.parseDate(dateString));
		notification.setUserId(userId);
		notification.setActiveFlag(true);
		notification.setBody(body);
		
		return notification;
	}
}
