package com.agilex.healthcare.mobilehealthplatform.repository.dao.notification;

import java.util.UUID;

import javax.annotation.Resource;
import javax.ws.rs.WebApplicationException;

import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.DeviceRegistrationDao;
import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.DeviceRegistrationMapper;
import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.DeviceRegistrationPo;
import com.agilex.healthcare.mobilehealthplatform.domain.DeviceRegistration;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class DeviceRegistrationDaoTestBase extends SpringBasedIntegrationRepo {

	@Resource
    protected DeviceRegistrationDao dao;
	
	protected DeviceRegistrationMapper mapper = new DeviceRegistrationMapper();
	protected String userId1;
	protected String userId2;
	protected String deviceToken1;
	protected String deviceToken2;
	protected DeviceRegistrationPo deviceRegistration1;
	protected DeviceRegistrationPo deviceRegistration2;

    @BeforeClass
    public static void checkWhetherTestsAreRunningInVeteranDevMode() {
    	System.out.println("currentMode=" + ModeHelper.getCurrentMode());
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
    }
	
	public void setUp(){
		userId1 = UUID.randomUUID().toString();
		userId2 = UUID.randomUUID().toString();
		
		deviceToken1 = "Fake DeviceToken";
		deviceToken2 = "Fake DeviceToken2";
		
		deviceRegistration1 = createAndSaveBasicDeviceRegistration(userId1, "1/1/2012", deviceToken1);
		deviceRegistration2 = createAndSaveBasicDeviceRegistration(userId2, "1/2/2012", deviceToken2);
	}
	
	public void tearDown(){
		dao.deleteDeviceRegistration(deviceRegistration1);
		dao.deleteDeviceRegistration(deviceRegistration2);
	}
	
	@Test
	@Ignore
	public void test() {
		assertTrue(true);
	}

	public DeviceRegistrationPo createAndSaveBasicDeviceRegistration(String userId, String dateString, String body) {
		DeviceRegistration deviceRegistration = createBasicDeviceRegistration(userId, dateString, body);
		DeviceRegistrationMapper mapper = new DeviceRegistrationMapper();
		DeviceRegistrationPo po = mapper.toPo(deviceRegistration);
		DeviceRegistrationPo savedDeviceRegistration = dao.saveDeviceRegistration(po);

		return savedDeviceRegistration;
	}

	public DeviceRegistration createBasicDeviceRegistration(String userId, String dateString, String deviceToken) {
		DeviceRegistration deviceRegistration = new DeviceRegistration();
		deviceRegistration.setRegisteredDate(DateHelper.parseDate(dateString));
		deviceRegistration.setUserId(userId);
		deviceRegistration.setDeviceToken(deviceToken);
		deviceRegistration.setFirstName(userId+"first");
		deviceRegistration.setLastName(userId+"last");
		deviceRegistration.setOptedIn(true);
		return deviceRegistration;
	}
	
	protected void verifyThere(DeviceRegistrationPo po, String msg) {
		try {
			// this throws an WebApplicationException if can't be found
			DeviceRegistrationPo saved = dao.fetchDeviceRegistrationById(po.getId());
			assertNotNull(msg,saved);
		} catch(WebApplicationException wae) {
			fail(msg);
		}
	}
}
