package com.agilex.healthcare.mobilehealthplatform.repository.dao.notification;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.notification.DeviceRegistrationPo;
import com.agilex.healthcare.mobilehealthplatform.domain.DeviceRegistration;

public class DeviceRegistrationDaoTest extends DeviceRegistrationDaoTestBase {
	
	@Before
	public void setUp() {
		super.setUp();
	}
	
	@After
	public void tearDown(){
		super.tearDown();
	}

	@Test
	public void verifyFetchForSingleUser() {
		List<DeviceRegistrationPo> fetchedDeviceRegistrations = dao.fetchDeviceRegistrations(userId1);
		assertNotNull(fetchedDeviceRegistrations);
		assertEquals(1, fetchedDeviceRegistrations.size());
	}

	@Test
	public void verifySaveFromDeviceRegistrationTranslation() {
		assertNotNull(deviceRegistration1);
	}

	@Test
	public void verifyUpdate() {
		String deviceToken = "updated token";
		deviceRegistration1.setDeviceToken(deviceToken);
		
		DeviceRegistrationPo updated = dao.saveDeviceRegistration(deviceRegistration1);
		assertEquals(deviceToken, updated.getDeviceToken());
		
		DeviceRegistrationPo retrievedForVerification = dao.fetchDeviceRegistration(userId1, deviceToken);
		assertNotNull(retrievedForVerification);
	}
	
	@Test
	public void verifyDeleteByObject() {
		String userId = UUID.randomUUID().toString();
		DeviceRegistrationPo deviceRegistration = createAndSaveBasicDeviceRegistration(userId, "1/1/2012", "Kill This Token");
		
		dao.deleteDeviceRegistration(deviceRegistration);
	
		DeviceRegistrationPo fetchedRegistrationThatShouldBeNull = dao.fetchDeviceRegistrationById(deviceRegistration.getId());
		assertNull(fetchedRegistrationThatShouldBeNull);
	}
	
	@Test
	public void verifyDeleteByToken() {
		String userId = UUID.randomUUID().toString();
		DeviceRegistrationPo deviceRegistration = createAndSaveBasicDeviceRegistration(userId, "1/1/2012", "Kill This Token");
		assertNotNull(deviceRegistration);
		
		dao.deleteDeviceRegistrationByToken(deviceRegistration.getDeviceToken());
		
		DeviceRegistrationPo fetchedRegistrationThatShouldBeNull = dao.fetchDeviceRegistrationById(deviceRegistration.getId());
		assertNull(fetchedRegistrationThatShouldBeNull);
	}
	
	@Test
	public void verifyFetchOfDeviceRegistrationsForMultipleUsers() {
		List<String> userIds = new ArrayList<String>();
		userIds.add(userId1);
		userIds.add(userId2);
		
		List<DeviceRegistrationPo> fetchedDeviceRegistrations = dao.fetchDeviceRegistrations(userIds);
		
		assertEquals(fetchedDeviceRegistrations.size(), 2);
		
		for (DeviceRegistrationPo fetchedDeviceRegistration : fetchedDeviceRegistrations) {
			if (fetchedDeviceRegistration.getUserId().equals(userId1)) {
				assertEquals(deviceToken1, fetchedDeviceRegistration.getDeviceToken());
			} else if (fetchedDeviceRegistration.getUserId().equals(userId2)) {
				assertEquals(deviceToken2, fetchedDeviceRegistration.getDeviceToken());
			} else {
				fail("Unexpected device registration");
			}
		}
	}
	
	@Test
	public void verifyOptOut() {
		String userId = UUID.randomUUID().toString();
		DeviceRegistration registration1 = createBasicDeviceRegistration(userId, "01/01/2012", "token1");
		registration1.setOptedIn(false);
		DeviceRegistrationPo po1 = mapper.toPo(registration1);
		dao.saveDeviceRegistration(po1);

		DeviceRegistration registration2 = createBasicDeviceRegistration(userId, "01/01/2012", "token2");
		DeviceRegistrationPo po2 = mapper.toPo(registration2);
		dao.saveDeviceRegistration(po2);

		List<DeviceRegistrationPo> registrations = dao.fetchDeviceRegistrations(userId);
		assertEquals(1, registrations.size());
	}
	
	@Test
	public void verifyOptStatusAfterUpdate() {
		createAndSaveBasicDeviceRegistration(userId1, "01/01/2012", "token1");
		createAndSaveBasicDeviceRegistration(userId1, "01/01/2012", "token2");
		
		dao.updateOptStatus(userId1, false);
		
		List<DeviceRegistrationPo> deviceRegistrations = dao.fetchDeviceRegistrations(userId1);
		assertEquals(0, deviceRegistrations.size());
		
		dao.updateOptStatus(userId1, true);
		
		deviceRegistrations = dao.fetchDeviceRegistrations(userId1);
		assertEquals(3, deviceRegistrations.size());
		
	}

}
