package com.agilex.healthcare.mobilehealthplatform.repository.dao.healthadvocaterequest;

import java.util.*;

import javax.annotation.Resource;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.healthadvocaterequest.*;
import com.agilex.healthcare.mobilehealthplatform.domain.HealthAdvocateStatusCode;
import com.agilex.healthcare.utility.DateHelper;

public class HealthAdvocateRequestResultDaoTest extends SpringBasedIntegrationRepo {

	@Resource
    HealthAdvocateRequestDao dao;

	String userId;
	HealthAdvocateRequestPo harResult;
	Date dateTaken;


	@Before
	public void before() {
		userId = UUID.randomUUID().toString();
		dateTaken = new Date();
	}

	@Test
	public void verifySaveOfBasicHealthAdvocateRequest() {
		String patientId = "1";
		harResult = createAndSaveBasicHealthAdvocateRequestResult(patientId, null, null);

		assertNotNull(harResult);
		String resultId = harResult.getId();
		assertNotNull(resultId);
		assertNotSame("",  resultId);
		
		String resultPatientId = harResult.getPatientEDIPI();
		assertNotNull(resultPatientId);
		assertNotSame("", resultPatientId);
	}
	
	@Test
	public void verifyOnlyMyself() {
		harResult = createAndSaveBasicHealthAdvocateRequestResult(userId, "0987654321", "NY");
		assertNotNull(dao.getHealthAdvocateRequest(userId, harResult.getId()));
		assertNull(dao.getHealthAdvocateRequest("other", harResult.getId()));
	}

	@Test
	public void verifyRetrieveSpecificResult() {
		String patientId = "1";
		harResult = createAndSaveBasicHealthAdvocateRequestResult(patientId, "0987654321", "NY");
		String resultId = harResult.getId();
		
		 HealthAdvocateRequestPo retrievedResultPo = dao.getHealthAdvocateRequest(patientId, resultId);

		assertNotNull(retrievedResultPo);
		String retrievedPatientId = retrievedResultPo.getPatientEDIPI();
		String retrievedId = retrievedResultPo.getId();
		
		assertNotNull(retrievedPatientId);
		assertNotSame("", retrievedPatientId);
		assertNotNull(retrievedId);
		assertNotSame("", retrievedId);
	}

	@Test
	public void verifyDriversLicenseInfoPersists() {
		String patientId = "1";
		String expectedLicenseNumber = "0987654321";
		String expectedLicenseState = "NY";
		harResult = createAndSaveBasicHealthAdvocateRequestResult(patientId, "0987654321", "NY");
		String resultId = harResult.getId();
		
		 HealthAdvocateRequestPo retrievedResultPo = dao.getHealthAdvocateRequest(patientId, resultId);

		 String resultDriversLicenseNumber = retrievedResultPo.getDriversLicenseNumber();
		 String resultDriversLicenseState = retrievedResultPo.getDriversLicenseState();
		 
		 assertEquals(expectedLicenseNumber, resultDriversLicenseNumber);
		 assertEquals(expectedLicenseState, resultDriversLicenseState);
		 
	}
	
	@Test
	public void testFormPersists() throws Exception {
		String patientId = "1";
		harResult = createAndSaveBasicHealthAdvocateRequestResult(patientId, null, null);		
		byte[] formData = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
		
		HealthAdvocateRequestFormPo form = new HealthAdvocateRequestFormPo(harResult, formData);
		form.setPatientId(UUID.randomUUID().toString());
		form.setStatus(HealthAdvocateStatusCode.SUBMITTED);
		form.setRequestId(harResult.getId());
		form.setRequestDate(new Date());
		dao.saveHealthAdvocateRequestForm(form);
		
		HealthAdvocateRequestFormPo result = dao.getHealthAdvocateRequestFormPo(harResult);
		
		for (int i = 0; i < formData.length; i++) {
			assertEquals(formData[i], result.getFormPDF()[i]);
		}
		
	}

//	@Test
//	public void verifySaveOfNewResult() {
//		createAndSaveBasicAssessmentResult(userId, dateTaken, 10, false, "testAssessmentId");
//		createAndSaveBasicAssessmentResult(userId, dateTaken, 12, false, "testAssessmentId");
//
//		List<AssessmentResultPo> savedAssessmentResults = dao.fetchAssessmentResults(userId);
//		assertNotNull(savedAssessmentResults);
//		assertEquals(2, savedAssessmentResults.size());
//	}
//
//	@Test
//	public void verifyFetchPreviouslyCompletedResult() {
//		String userId = UUID.randomUUID().toString();
//		Date oldestDate = DateHelper.getPreviousMonth();
//		Date middleDate = DateHelper.getYesterday();
//		Date newestDate = DateHelper.getToday();
//
//		assessmentResult = createAndSaveBasicAssessmentResult(userId, oldestDate, 12, false, "testAssessmentId");
//		assessmentResult = createAndSaveBasicAssessmentResult(userId, middleDate, 11, false, "testAssessmentId");
//		assessmentResult = createAndSaveBasicAssessmentResult(userId, newestDate, 10, false, "testAssessmentId");
//		assessmentResult = createAndSaveBasicAssessmentResult(userId, newestDate, 10, false, "differentAssessmentId");
//
//		List<AssessmentResultPo> previouslyCompletedResults = dao.fetchPreviouslyCompletedResults("testAssessmentId", new PatientIdentifier("default",
//				userId));
//		assertEquals(3, previouslyCompletedResults.size());
//	}
//
//	public void verifySaveOfDraft() {
//		createAndSaveBasicAssessmentResult(userId, dateTaken, 10, true, "testAssessmentId");
//		createAndSaveBasicAssessmentResult(userId, dateTaken, 12, false, "testAssessmentId");
//
//		List<AssessmentResultPo> savedAssessmentResults = dao.fetchAssessmentResults(userId);
//		assertNotNull(savedAssessmentResults);
//		assertEquals(1, savedAssessmentResults.size());
//	}
//

	private HealthAdvocateRequestPo createAndSaveBasicHealthAdvocateRequestResult(String patientId, String driversLicenseNumber, String driversLicenseState) {
		HealthAdvocateRequestPo harResult = new HealthAdvocateRequestPo();
		harResult.setAddressFirstLine("");
		harResult.setAddressSecondLine("");
		harResult.setCity("");
		harResult.setEmail("");
		harResult.setFirstName("");
		harResult.setHealthAdvocateEDIPI("");
		harResult.setId("");
		harResult.setLastActionDate(DateHelper.getToday());
		harResult.setLastName("");
		harResult.setPatientEDIPI(patientId);
		harResult.setPatientName("");
		harResult.setPatientDisplayName("");
		harResult.setRequestDate(DateHelper.getToday());
		harResult.setState("");
		harResult.setStatus("");
		harResult.setUriLinkKey("");
		harResult.setUserId("");
		harResult.setZipCode("");
		harResult.setDriversLicenseNumber(driversLicenseNumber);
		harResult.setDriversLicenseState(driversLicenseState);
		
		return dao.createOrUpdateNewHealthAdvocateRequest(harResult);
	}
}