package com.agilex.healthcare.mobilehealthplatform.repository.dao.contactlog;

import javax.annotation.Resource;

import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.contactlog.ContactLogDao;
import com.agilex.healthcare.mobilehealthplatform.domain.ContactLog;
import com.agilex.healthcare.mobilehealthplatform.domain.ContactLogs;

@Ignore
@Deprecated
public class ContactLogPedTest extends SpringBasedIntegrationRepo {

	@Resource
    ContactLogDao dao;

	private void init(String patientId) {
		ContactLog log = new ContactLog();
		log.setActivity("act-01");
		log.setContact("con-01");
		log.setNote("not-01");
		log.setTask("tas-01");
		log.setPatientId(patientId);
		dao.save(log);

		log = new ContactLog();
		log.setActivity("act-02");
		log.setContact("con-02");
		log.setNote("not-02");
		log.setTask("tas-02");
		log.setPatientId(patientId);
		dao.save(log);

		log = new ContactLog();
		log.setActivity("act-03");
		log.setContact("con-03");
		log.setNote("not-03");
		log.setTask("tas-03");
		log.setPatientId(patientId);
		dao.save(log);

		log = new ContactLog();
		log.setActivity("act-04");
		log.setContact("con-04");
		log.setNote("not-04");
		log.setTask("tas-04");
		log.setPatientId(patientId);
		dao.save(log);

		log = new ContactLog();
		log.setActivity("act-05");
		log.setContact("con-05");
		log.setNote("not-05");
		log.setTask("tas-05");
		log.setPatientId(patientId);
		dao.save(log);
	}

	@Test
	public void testGetAll() {
		init("01");
		ContactLogs logs = dao.get("01");
		assertNotNull(logs);
		assertTrue(logs.size() + " was not greater than or equal to 5", logs.size() >= 5);
	}

	@Test
	public void testSave() {
		ContactLog log = new ContactLog();
		log.setActivity("act-05");
		log.setContact("con-05");
		log.setNote("not-05");
		log.setTask("tas-05");
		log.setPatientId("05");

		ContactLog savedContactLog = dao.save(log);
		assertNotNull(savedContactLog);

		ContactLog retrieved = dao.get("05", savedContactLog.getId());
		assertNotNull(retrieved);
	}

	@Test
	public void testDelete() {
		ContactLog log = new ContactLog();
		log.setActivity("act-06");
		log.setContact("con-06");
		log.setNote("not-06");
		log.setTask("tas-06");
		log.setPatientId("06");

		ContactLog savedContactLog = dao.save(log);
		assertNotNull(savedContactLog);
		assertNotNull(savedContactLog.getId());

		dao.delete(savedContactLog);

		ContactLog retrievedLog = dao.get("06", savedContactLog.getId());
		assertNull(retrievedLog);
	}

	@Test
	public void testUpdate() {
		ContactLog log = new ContactLog();
		log.setActivity("act-07");
		log.setContact("con-07");
		log.setNote("not-07");
		log.setTask("tas-07");
		log.setPatientId("07");

		ContactLog savedContactLog = dao.save(log);
		assertNotNull(savedContactLog);
		assertNotNull(savedContactLog.getId());
		String logId = savedContactLog.getId();
		assertEquals("act-07", savedContactLog.getActivity());
		assertEquals("con-07", savedContactLog.getContact());
		assertEquals("not-07", savedContactLog.getNote());
		assertEquals("tas-07", savedContactLog.getTask());
		assertEquals("07", savedContactLog.getPatientId());

		savedContactLog.setNote("changedNote");
		ContactLog retrievedLog = dao.save(savedContactLog);
		assertNotNull(retrievedLog);
		assertEquals("changedNote", retrievedLog.getNote());
		assertEquals(logId, retrievedLog.getId());

	}

}
