package com.agilex.healthcare.mobilehealthplatform.datalayer.userhistory;

import com.agilex.healthcare.mobilehealthplatform.datalayer.UserHistoryIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.mood.MoodPo;
import com.agilex.healthcare.mobilehealthplatform.domain.MoodEvent;
import org.junit.Test;

import javax.persistence.TypedQuery;
import java.util.*;

public class UserHistoryEntityManagerTest extends UserHistoryIntegrationRepo {

    public static final String UNIQUE_ID = "abc";
    public static final String PATIENT_ID = "12345";
    public static final String SURROGATE_ID = "67890";

    @Test
    public void update() {
        MoodEvent event = createMoodEvent(false);
        event.setUniqueId(UNIQUE_ID);

        UserHistoryEntityManager<MoodPo> simpleEntityManager = new UserHistoryEntityManager<MoodPo>(entityManager, "MOOD", event);
        MoodPo po = simpleEntityManager.save(new MoodPo(event));

        verifyUserHistory(po.getId(), PATIENT_ID, UserHistoryPo.UPDATE_OP);
    }

    @Test
    public void delete() {
        MoodEvent event = insertMoodEvent();

        UserHistoryEntityManager<MoodPo> simpleEntityManager = new UserHistoryEntityManager<MoodPo>(entityManager, "MOOD");
        simpleEntityManager.delete(event, MoodPo.class);

        List<UserHistoryPo> result =  findByUserId(SURROGATE_ID);

        assertEquals(2, result.size());

        boolean deleteOpFound = false;

        for(UserHistoryPo po: result) {
            deleteOpFound = deleteOpFound || po.getOperation().equals(UserHistoryPo.DELETE_OP);
        }

        assertTrue(deleteOpFound);
    }

    private MoodEvent insertMoodEvent() {
        MoodEvent event = createMoodEvent(true);

        UserHistoryEntityManager<MoodPo> simpleEntityManager = new UserHistoryEntityManager<MoodPo>(entityManager, "MOOD", event);
        MoodPo po = simpleEntityManager.save(new MoodPo(event));

        verifyUserHistory(po.getId(), SURROGATE_ID, UserHistoryPo.INSERT_OP);

        event.setUniqueId(po.getId());
        return event;
    }

    private MoodEvent createMoodEvent(boolean includeSurrogateId) {
        MoodEvent event = new MoodEvent();
        event.setPatientId(PATIENT_ID);
        event.setDate(new Date());
        event.setValue("Happy");

        if (includeSurrogateId)
            event.setSurrogateIdentifier("default", SURROGATE_ID);

        return event;
    }

    public void verifyUserHistory(String id, String userId, String operation) {
        List<UserHistoryPo> result =  findByUserId(userId);

        UserHistoryPo po = result.get(0);

        assertEquals(id, po.getRowId());
        assertEquals(userId, po.getUserId());
        assertEquals(operation, po.getOperation());
        assertEquals("MOOD", po.getTableName());
    }

    private List<UserHistoryPo> findByUserId(String userId) {
        TypedQuery<UserHistoryPo> query = entityManager.createQuery("from UserHistoryPo where userId = :userId", UserHistoryPo.class);
        query.setParameter("userId", userId);


        return query.getResultList();
    }
}
