package com.agilex.healthcare.mobilehealthplatform.datalayer.tooltrackingresult;

import java.util.Date;
import java.util.UUID;

import javax.annotation.Resource;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.trackedtool.ToolTrackingResultDataLayerRepo;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolTrackingResult;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolTrackingResults;
import com.agilex.healthcare.mobilehealthplatform.domain.code.ToolTrackingCode;

public class ToolTrackingResultDataLayerRepoTest extends SpringBasedIntegrationRepo {

	@Resource
	ToolTrackingResultDataLayerRepo dataLayer;
	
	ToolTrackingResult tool;
	String patientId;
	
	@Before
	public void before() {
		patientId = UUID.randomUUID().toString();
		this.tool = createTrackedTool();
	}
	
	@After
	public void after() {
		dataLayer.delete(tool);
	}
	
	@Test
	public void verifySave() {
		assertNotNull(tool);
		assertNotNull(tool.getUniqueId());
		assertEquals(patientId, tool.getPatientId());
		assertNotNull(tool.getDateTracked());
	}
	
	@Test
	public void verifyFetchSingle() {
		ToolTrackingResult fetched = dataLayer.fetchItem(patientId, tool.getUniqueId());
		assertNotNull(fetched);
		assertEquals(fetched.getUniqueId(), tool.getUniqueId());
		assertEquals(fetched.getFrequency(), tool.getFrequency());
		assertEquals(fetched.getSuccessRate(), tool.getSuccessRate());
		assertEquals(fetched.getUsefulness(), tool.getUsefulness());
		assertEquals(fetched.getTool(), tool.getTool());
	}
	
	@Test
	public void verifyFetchMany() {
        ToolTrackingResult second = createTrackedTool();
        ToolTrackingResults fetched = dataLayer.fetchItems(patientId);

		assertEquals(2, fetched.size());
		
		dataLayer.delete(second);
	}
	
	@Test
	public void verifyFetchMostRecent() {
		ToolTrackingResult second = createTrackedTool();
		ToolTrackingResult shouldBeMostRecent = dataLayer.fetchMostRecentItem(patientId, ToolTrackingCode.DEEP_BREATHING);
		
		assertEquals(second.getUniqueId(), shouldBeMostRecent.getUniqueId());
	}
	
	public ToolTrackingResult createTrackedTool() {
		ToolTrackingResult tool = new ToolTrackingResult();
		tool.setPatientId(patientId);
		tool.setTool(ToolTrackingCode.DEEP_BREATHING);
		tool.setFrequency("Daily");
		tool.setUsefulness(40);
		tool.setDateTracked(new Date());
		tool.setSuccessRate(100);
		
		tool = dataLayer.update(tool);
		
		return tool;
	}
	
}
