package com.agilex.healthcare.mobilehealthplatform.datalayer.staffuserdisclaimer;

import java.util.Date;

import javax.annotation.Resource;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.domain.StaffUserDisclaimerContent;
import com.agilex.healthcare.mobilehealthplatform.domain.StaffUserDisclaimerInfo;
import com.agilex.healthcare.utility.NullChecker;

public class StaffUserDisclaimerDataLayerRepoTest extends SpringBasedIntegrationRepo {
	
	@Resource
	StaffUserDisclaimerDao dao;
	
	StaffUserDisclaimerDataLayerRepo datalayer;

	@Before
	public void setupData() throws Exception {
		datalayer = new StaffUserDisclaimerDataLayerRepo(dao);
		datalayer.saveStaffUserDisclaimerInfo(generateStaffUserDisclaimerInfo("TESTLOCATION", "TESTUSERTRUE", true));
		datalayer.saveStaffUserDisclaimerInfo(generateStaffUserDisclaimerInfo("TESTLOCATION", "TESTUSERFALSE", false));
	}

	@After
	public void removeData() throws Exception {
		// int test should be running in-memory db, cleared after every launch
	}

	@Test
	public void verifySaveThenGetLatestStaffUserDisclaimerContent() {
		StaffUserDisclaimerContent content = null;
		content = datalayer.saveStaffUserDisclaimerContent(generateContent());
		assertNotNull(content);
		content = datalayer.saveStaffUserDisclaimerContent(generateContent("test2"));
		assertNotNull(content);
		
		content = datalayer.getLatestStaffUserDisclaimerContent();
		assertNotNull(content);
		assertTrue(NullChecker.isNotNullish(content.getContent()));
		assertTrue(NullChecker.isNotNullish(content.getDate()));
		
		assertEquals("test2", content.getContent());
	}
	
	private StaffUserDisclaimerContent generateContent() {
		return generateContent(getContentHtml());
	}
	
	private String getContentHtml() {
		StringBuilder sb = new StringBuilder();
		
		sb.append("<h3>UNITED STATES DEPARTMENT OF VETERANS AFFAIRS (\"VA\")</h3>");
		sb.append("<h4>WEB & MOBILE USER DISCLAIMER (UD) FOR VA EMPLOYEES</h4>");
		sb.append("<p>By agreeing to have any of VAs software products delivered by web and mobile technology to your Government Furnished Equipment (GFE) or personal device and by subsequent use of the Licensed Software, you agree to comply with the terms of this general Web & Mobile User Disclaimer (UD). If you do not agree to the terms of this UD, do not use the Licensed Software. This UD applies to any upgrades and supplements to the original Licensed Software provided and is available from within the VA application.</p>");
		sb.append("<ol>");
		sb.append("<li>The Licensed Software is owned by VA. The Licensed Software is licensed, not sold, only on the terms of this UD. Use of the software indicates your acceptance of the terms and conditions of this UD.</li>");
		sb.append("<li>Upon accessing the Licensed Software on your GFE or personal device, you acknowledge that you are a VA employee and will acquire the right to use the Licensed Software, directly from VA as part of your VA employment. You assume responsibility for the selection of the program to achieve your intended results, and for the accessing, use and results obtained from the Licensed Software.</li>");
		sb.append("<li>VA and you acknowledge that this Agreement is concluded between VA and you only, and not with your device manufacturer. VA is solely responsible for the Licensed Software and its content.</li>");
		sb.append("<li>You are provided the right to use the Licensed Software because you are a VA employee. As a VA employee you are responsible for complying with all VA policies and regulations while performing your official VA duties including when using the Licensed Software. Your use of the Licensed Software must comply at all times with the VA Rules of Behavior you sign annually.</li>");
		sb.append("<li>PRIVACY NOTICE: The Licensed Software does not allow for the storage of data on your GFE or personal device. VA Sensitive Information, including but not limited to Protected Health Information (PHI) and other forms of Personally Identifiable Information (PII), may be securely transmitted from VA to your GFE or personal device using this Licensed Software. You acknowledge that any data provided to you using this Licensed Software is done so under your authority as a VA employee and for your official VA duties only. You acknowledge that it is your sole responsibility to protect and otherwise secure any information viewable by the software once installed on your GFE or personal device.</li>");
		sb.append("<li>In consideration of your acceptance of the terms and conditions contained in this UD, VA grants you a non-exclusive license to use the Licensed Software and the associated documentation for your official VA duties. You are not licensed to rent, lease, transfer, or distribute the Licensed Software.</li>");
		sb.append("<li>The license is effective upon acceptance and use or installation of the Licensed Software and shall continue until terminated. You may terminate it at any time by uninstalling the Licensed Software or ceasing use of the web-delivered application. VA has the right to terminate this Agreement if you fail to comply with any term or condition of this UD or the VA Rules of Behavior, or you leave VA employment. Upon termination you shall stop all use of the Software and uninstall the Licensed Software, if it has been installed on your personal device.</li>");
		sb.append("<li>VA shall be neither liable nor responsible for any maintenance or updating of the provided Licensed Software, nor for correction of any errors in the Licensed Software. As a VA employee you are responsible for ensuring the Licensed Software is updated, as appropriate.</li>");
		sb.append("<li>If any provision of this Agreement is held to be invalid or unenforceable the remaining provisions will not be affected.</li>");
		sb.append("</ol>");
			
		return sb.toString();
	}

	private StaffUserDisclaimerContent generateContent(String content) {
		StaffUserDisclaimerContent dto = new StaffUserDisclaimerContent();
		dto.setContent(content);
		dto.setDate(new Date());
		return dto;
	}
	
	@Test
	public void verifyFetchOfStaffUserDisclaimerInfoAccepted() {
		StaffUserDisclaimerInfo info = datalayer.getStaffUserDisclaimerInfo("TESTLOCATION", "TESTUSERTRUE");
		assertEquals(true, info.isStaffUserDisclaimerAccepted());
	}
	
	@Test
	public void verifyFetchOfStaffUserDisclaimerInfoNotAccepted() {
		StaffUserDisclaimerInfo info = datalayer.getStaffUserDisclaimerInfo("TESTLOCATION", "TESTUSERFALSE");
		assertEquals(false, info.isStaffUserDisclaimerAccepted());
	}
	
	@Test
	public void verifyFetchOfStaffUserDisclaimerInfoNonExistent() {
		boolean accepted = false;
		try {
			StaffUserDisclaimerInfo info = datalayer.getStaffUserDisclaimerInfo("NONE", "NONE");
			accepted = (info == null) ? false : info.isStaffUserDisclaimerAccepted();
		} catch (WebApplicationException e) {
			if (e.getResponse().getStatus() == Status.PRECONDITION_FAILED.getStatusCode()) {
				accepted = true;
			}
		}
		
		assertEquals(false, accepted);
	}

	private StaffUserDisclaimerInfo generateStaffUserDisclaimerInfo(String vistaLocation, String userId, boolean accepted) {
		StaffUserDisclaimerInfo info = new StaffUserDisclaimerInfo();
		info.setStaffUserDisclaimerAccepted(accepted);
		info.setStaffUserDisclaimerDate(new Date());
		info.setUserId(userId);
		info.setVistaLocation(vistaLocation);
		
		return info;
	}
}