package com.agilex.healthcare.mobilehealthplatform.datalayer.preference;

import java.util.UUID;

import javax.annotation.Resource;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientPreference;

public class PatientPreferenceDataLayerRepoTest extends SpringBasedIntegrationRepo {

	@Resource
	PatientPreferenceDataLayerRepo dataLayer;
	
	PatientPreference patientPreference;
	String patientId;
	
	@Before
	public void before() {
		patientId = UUID.randomUUID().toString();
		patientPreference = updatePatientPreferenceObject(patientId);
	}
	
	@After
	public void after() {
		dataLayer.deletePatientPreference(patientPreference);
	}
	
	@Test
	public void getPatientPreferenceTest() {
		PatientPreference pref = dataLayer.updatePatientPreference(patientPreference);
		PatientPreference preference = dataLayer.fetchPatientPreference(pref.getPatientIdentifier());
		assertNotNull(preference);
	}
	
	@Test
	public void savePatientPreferenceTest() {			
		PatientPreference preference = dataLayer.updatePatientPreference(patientPreference);
		assertNotNull(preference);
	}
	
	@Test
	public void updatePatientPreferenceRemoveEmailAddressTest(){
		PatientPreference pref = dataLayer.updatePatientPreference(patientPreference);
		assertNotNull(pref);
		pref.setEmailAddress(null);
		pref.setEmailAllowed(false);
		PatientPreference updatedPreference = dataLayer.updatePatientPreference(pref);
		assertNotNull(updatedPreference);
		assertEquals(false, updatedPreference.isEmailAllowed());
		assertEquals(null, updatedPreference.getEmailAddress());
	}
	
	@Test
	public void updatePatientPreferenceAddEmailAddressTest(){
		patientPreference.setEmailAddress(null);
		patientPreference.setEmailAllowed(false);
		PatientPreference pref = dataLayer.updatePatientPreference(patientPreference);
		assertNotNull(pref);
		pref.setEmailAddress("newAddress@xyz.com");
		pref.setEmailAllowed(true);
		PatientPreference updatedPreference = dataLayer.updatePatientPreference(pref);
		assertNotNull(updatedPreference);
		assertEquals(true, updatedPreference.isEmailAllowed());
		assertEquals("newAddress@xyz.com", updatedPreference.getEmailAddress());
	}
	
	@Test
	public void updatePatientPreferenceRemoveSMSPreferenceTest(){
		PatientPreference pref = dataLayer.updatePatientPreference(patientPreference);
		assertNotNull(pref);
		pref.setTextMsgAllowed(false);
		pref.setTextMsgPhNumber(null);
		PatientPreference updatedPreference = dataLayer.updatePatientPreference(pref);
		assertNotNull(updatedPreference);
		assertEquals(false, updatedPreference.isTextMsgAllowed());
		assertEquals(null, updatedPreference.getTextMsgPhNumber());
	}
	
	@Test
	public void updatePatientPreferenceAddSMSPreferenceTest(){
		patientPreference.setTextMsgAllowed(false);
		patientPreference.setTextMsgPhNumber(null);
		PatientPreference pref = dataLayer.updatePatientPreference(patientPreference);
		assertNotNull(pref);
		pref.setTextMsgAllowed(true);
		pref.setTextMsgPhNumber("111-111-1111");
		PatientPreference updatedPreference = dataLayer.updatePatientPreference(pref);
		assertNotNull(updatedPreference);
		assertEquals(true, updatedPreference.isTextMsgAllowed());
		assertEquals("111-111-1111", updatedPreference.getTextMsgPhNumber());
	}
	
	public PatientPreference updatePatientPreferenceObject(String patientId){
		PatientPreference pref = new PatientPreference();
		PatientIdentifier pId = new PatientIdentifier();
		pId.setUniqueId(patientId);
		pref.setPatientId(patientId);
		pref.setNotificationFrequency("Each new message");
		pref.setEmailAddress("abc1234@xyz.com");
		pref.setEmailAllowed(true);
		pref.setTextMsgAllowed(true);
		pref.setTextMsgPhNumber("(703) 123-4567");
		pref.setPatientIdentifier(pId);
		
		return pref;
	}
}
