package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import java.util.Date;
import java.util.List;
import java.util.UUID;

import javax.annotation.Resource;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientMetadata;

public class PatientMetadataDataLayerRepoTest extends SpringBasedIntegrationRepo {
	@Resource
	PatientMetadataDataLayerRepo datalayer;

	public PatientMetadataDataLayerRepoTest() {
	}
	
	@Test
	public void validateNumberOfPatientMetadataList() {
		List<PatientMetadata> patientMetadataList = datalayer.fetchPatientMetadataList();
		assertNotNull(patientMetadataList);
		
		for (PatientMetadata patientMetadata : patientMetadataList) {
			assertNotNull(patientMetadata.getPatientId());
		}
	}
	
	@Test
	public void verifySaveAndFetchOfBasicAppointmentRequest() {
		String patientId = UUID.randomUUID().toString();
		Date now = new Date();
		
		PatientMetadata metadata = new PatientMetadata();
		metadata.setPatientId(patientId);
		metadata.setLastAppointmentRequestAccessDate(now);
		
		PatientMetadata savedMetadata = datalayer.savePatientMetadata(metadata);
		assertNotNull(savedMetadata);
		assertEquals(patientId, savedMetadata.getPatientId());
		assertEquals(now, savedMetadata.getLastAppointmentRequestAccessDate());
	}
}