package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

import javax.annotation.Resource;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.domain.DOBDate;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientEdipiIcn;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.utility.NullChecker;

public class PatientInternalDataLayerRepoTest extends SpringBasedIntegrationRepo {
	@Resource
	PatientInternalDataLayerRepo datalayer;
	
	Patient patient;

	public PatientInternalDataLayerRepoTest() {
		patient = new Patient();
		patient.setId("TEST.PATI3NT");
		patient.setFirstName("TEST");
		patient.setLastName("PATI3NT");
		patient.setDateOfBirth(new DOBDate(new Date()));
		patient.setSsn("234232345");
		patient.setTextMessagingAllowed(false);
		patient.setTextMessagingPhoneNumber("");
	}
	
	@Before
	public void init() {
		datalayer.savePatient(patient);
	}
	
	@After
	public void destroy() {
		datalayer.removePatient(patient.getId());
	}
	
	@Test
	public void validatefetchAllPatients() {
		Patients patients = datalayer.fetchPatients();
		assertNotNull(patients);
		assertTrue(patients.size() > 0);
		
		for (Patient patient : patients) {
			assertPatient(patient);
		}
	}
	@Test
	public void validateFetchPatientById() {
		Patient testPatient = datalayer.fetchPatientById(patient.getId());
		
		assertPatient(testPatient);
	}
	

	@Test
	public void validateSavePatientICN() {
		Collection<PatientEdipiIcn> patientEdipiIcns = new HashSet<PatientEdipiIcn>();
		PatientEdipiIcn patientEdipiIcn = new PatientEdipiIcn();
		patientEdipiIcn.setEdipi("12345");
		patientEdipiIcn.setIcn("12345V000");
		patientEdipiIcns.add(patientEdipiIcn);
		List<PatientEdipiIcn> savedPatientEdipiIcns = datalayer.savePatientICN(patientEdipiIcns);
		
		assertPatientEdipiIcn(savedPatientEdipiIcns);
	}

	@Test
	public void validateDuplicateSavePatientICN() {
		Collection<PatientEdipiIcn> patientEdipiIcns = new HashSet<PatientEdipiIcn>();
		PatientEdipiIcn patientEdipiIcn = new PatientEdipiIcn();
		patientEdipiIcn.setEdipi("12345");
		patientEdipiIcn.setIcn("12345V000");
		patientEdipiIcns.add(patientEdipiIcn);
		List<PatientEdipiIcn> savedPatientEdipiIcns = datalayer.savePatientICN(patientEdipiIcns);
		
		assertPatientEdipiIcn(savedPatientEdipiIcns);
		
		patientEdipiIcns = new HashSet<PatientEdipiIcn>();
		patientEdipiIcn = new PatientEdipiIcn();
		patientEdipiIcn.setEdipi("12345");
		patientEdipiIcn.setIcn("12345V000");
		patientEdipiIcns.add(patientEdipiIcn);
		savedPatientEdipiIcns = datalayer.savePatientICN(patientEdipiIcns);
		
		assertTrue(savedPatientEdipiIcns.isEmpty());
		
	}

	@Test
	public void validateSaveMultiplePatientICNs() {
		Collection<PatientEdipiIcn> patientEdipiIcns = new HashSet<PatientEdipiIcn>();
		PatientEdipiIcn patientEdipiIcn = new PatientEdipiIcn();
		patientEdipiIcn.setEdipi("12345");
		patientEdipiIcn.setIcn("12345V000");
		patientEdipiIcns.add(patientEdipiIcn);
		patientEdipiIcn = new PatientEdipiIcn();
		patientEdipiIcn.setEdipi("123455");
		patientEdipiIcn.setIcn("12345V0001");
		patientEdipiIcns.add(patientEdipiIcn);
		patientEdipiIcn = new PatientEdipiIcn();
		patientEdipiIcn.setEdipi("123455");
		patientEdipiIcn.setIcn("12345V0001");
		patientEdipiIcns.add(patientEdipiIcn);
		List<PatientEdipiIcn> savedPatientEdipiIcns = datalayer.savePatientICN(patientEdipiIcns);
		
		assertTrue(savedPatientEdipiIcns.size() == 2);
		assertPatientEdipiIcn(savedPatientEdipiIcns);
		
	}
	
	public void assertPatient(Patient patient) {
		assertTrue(NullChecker.isNotNullish(patient.getFirstName()));
		assertTrue(NullChecker.isNotNullish(patient.getLastName()));
		assertTrue(NullChecker.isNotNullish(patient.getId()));
		assertTrue(NullChecker.isNotNullish(patient.getSsn()));
		assertTrue(patient.getDateOfBirth() != null);
	}
	
	public void assertPatientEdipiIcn(List<PatientEdipiIcn> savedPatientEdipiIcns) {
		for (PatientEdipiIcn patientEdipiIcn : savedPatientEdipiIcns) {
			assertTrue(NullChecker.isNotNullish(patientEdipiIcn.getEdipi()));
			assertTrue(NullChecker.isNotNullish(patientEdipiIcn.getIcn()));
			assertTrue(NullChecker.isNotNullish(patientEdipiIcn.getId()));
			assertTrue(patientEdipiIcn.isActiveFlag());
		}
	}	
}