package com.agilex.healthcare.mobilehealthplatform.datalayer.notification;

import java.util.UUID;

import javax.annotation.Resource;

import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.domain.Notification;
import com.agilex.healthcare.mobilehealthplatform.domain.Notifications;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.utility.ModeHelper;

public class NotificationDataLayerRepoTest extends SpringBasedIntegrationRepo {

	@Resource
	private NotificationDataLayerRepo dataLayer;
	
	private Notification notification;
	private String userId;

    @BeforeClass
    public static void checkWhetherTestsAreRunningInVeteranDevMode() {
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
    }

	@Before
	public void before() {
		this.userId = UUID.randomUUID().toString();
		this.notification = createAndSaveNotification();
	}
	
	@After
	public void after() {
		dataLayer.deleteNotification(notification);
	}
	
	@Test
	public void verifySaveWithoutDateSet() {
		assertNotNull(notification);
		assertNotNull(notification.getDate());
	}
	
	@Test
	public void verifyCountWhenFewerThanMax() {
		generateNotifications(30); // + the notification from before();
		
		Notifications shouldBe31Notifications = dataLayer.getActiveNotifications(userId, DateFilterFactory.createEmptyFilter());
		assertEquals(31, shouldBe31Notifications.size());
	}
	
	@Test
	public void verifyCountWhenMoreThanMax() {
		generateNotifications(55);
		
		Notifications shouldBe50Notifications = dataLayer.getActiveNotifications(userId, DateFilterFactory.createEmptyFilter());
		assertEquals(50, shouldBe50Notifications.size());
	}
	
	private Notification createAndSaveNotification() {
		Notification notification = new Notification();
		notification.setActiveFlag(true);
		notification.setBody("body");
		notification.setPatientId(this.userId);
		
		Notification savedNotification = dataLayer.saveNotification(notification);
		
		return savedNotification;
	}
	
	private void generateNotifications(int count) {
		for(int i = 0; i < count; i++) {
			createAndSaveNotification();
		}
	}
}
