package com.agilex.healthcare.mobilehealthplatform.datalayer.mygoals;

import java.text.SimpleDateFormat;
import java.util.Date;

import javax.annotation.Resource;

import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.domain.Mygoals;
import com.agilex.healthcare.mobilehealthplatform.domain.MygoalsList;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.enumeration.MygoalsInventoryType;

public class MygoalsDataLayerRepoTest extends SpringBasedIntegrationRepo {

    private static PatientIdentifier aldieId = new PatientIdentifier("EDIPI", "0000000002");
    
    @Resource
    MygoalsDataLayerRepo dataLayer;

    private MygoalsList feelingsMygoalsList = new MygoalsList();
    private MygoalsList currentAndDesiredStateMygoalsList = new MygoalsList();
    private MygoalsList reflectionsMygoalsList = new MygoalsList();
    private MygoalsList prioritiesMygoalsList = new MygoalsList();
    
	DateTime today = new DateTime();
	Date twoWeeksAgo = today.minusDays(14).toDate();
 
    @Before
    public void setup() {
    	MygoalsList feelingsMygoals = createFeelScaleMygoals();
    	for (Mygoals mygoals : feelingsMygoals) {
    		Mygoals resultmygoals = dataLayer.saveMygoals(mygoals);
    		feelingsMygoalsList.add(resultmygoals);
		}
    	MygoalsList currAndDesireMygoals = createCurrentAndDesiredStateMygoals();
    	for (Mygoals mygoals : currAndDesireMygoals) {
    		Mygoals resultmygoals = dataLayer.saveMygoals(mygoals);
    		currentAndDesiredStateMygoalsList.add(resultmygoals);
		}
    	MygoalsList reflectionMygoals = createReflectionsMygoals();
    	for (Mygoals mygoals : reflectionMygoals) {
    		Mygoals resultmygoals = dataLayer.saveMygoals(mygoals);
    		reflectionsMygoalsList.add(resultmygoals);
		}
    	MygoalsList prioritiesMygoals = createPrioritiesMygoals();
    	for (Mygoals mygoals : prioritiesMygoals) {
    		Mygoals resultmygoals = dataLayer.saveMygoals(mygoals);
    		prioritiesMygoalsList.add(resultmygoals);
		}	
    }

    private MygoalsList createFeelScaleMygoals() {
   	
		MygoalsList mygoalsList = new MygoalsList();
		Mygoals firstQuestion = createMygoals(aldieId, MygoalsInventoryType.FEELINGS.name(), "feelings-physically", "4", twoWeeksAgo);
		mygoalsList.add(firstQuestion);
		Mygoals secondQuestion = createMygoals(aldieId, MygoalsInventoryType.FEELINGS.name(), "feelings-mentally", "5", twoWeeksAgo);
		mygoalsList.add(secondQuestion);
		Mygoals thirdQuestion = createMygoals(aldieId, MygoalsInventoryType.FEELINGS.name(), "feelings-day-to-day", "6", twoWeeksAgo);
		mygoalsList.add(thirdQuestion);

		firstQuestion = createMygoals(aldieId, MygoalsInventoryType.FEELINGS.name(), "feelings-physically", "4", today.toDate());
		mygoalsList.add(firstQuestion);
		secondQuestion = createMygoals(aldieId, MygoalsInventoryType.FEELINGS.name(), "feelings-mentally", "5", today.toDate());
		mygoalsList.add(secondQuestion);
		thirdQuestion = createMygoals(aldieId, MygoalsInventoryType.FEELINGS.name(), "feelings-day-to-day", "6", today.toDate());
		mygoalsList.add(thirdQuestion);
		return mygoalsList;
    }

    private MygoalsList createCurrentAndDesiredStateMygoals() {
   
		MygoalsList mygoalsList = new MygoalsList();
		Mygoals firstQuestion = createMygoals(aldieId, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Current-body-slider", "3", twoWeeksAgo);
		mygoalsList.add(firstQuestion);
		Mygoals secondQuestion = createMygoals(aldieId, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Current-body-items", "CurrentAndDesiredState_answer1|CurrentAndDesiredState_answer11|CurrentAndDesiredState_answer111", twoWeeksAgo);
		mygoalsList.add(secondQuestion);
		Mygoals thirdQuestion = createMygoals(aldieId, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Desired-body-slider", "4", twoWeeksAgo);
		mygoalsList.add(thirdQuestion);
		Mygoals fourthQuestion = createMygoals(aldieId, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Desired-body-items", "CurrentAndDesiredState_answer2|CurrentAndDesiredState_answer22|CurrentAndDesiredState_answer222", twoWeeksAgo);
		mygoalsList.add(fourthQuestion);
		Mygoals fifthQuestion = createMygoals(aldieId, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Current-recharge-slide", "5", twoWeeksAgo);
		mygoalsList.add(fifthQuestion);
		Mygoals sixthQuestion = createMygoals(aldieId, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Current-recharge-items", "CurrentAndDesiredState_answer3|CurrentAndDesiredState_answer33|CurrentAndDesiredState_answer333", twoWeeksAgo);
		mygoalsList.add(sixthQuestion);
		
		firstQuestion = createMygoals(aldieId, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Current-body-slider", "3", today.toDate());
		mygoalsList.add(firstQuestion);
		secondQuestion = createMygoals(aldieId, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Current-body-items", "CurrentAndDesiredState_answer1|CurrentAndDesiredState_answer11|CurrentAndDesiredState_answer111", today.toDate());
		mygoalsList.add(secondQuestion);
		thirdQuestion = createMygoals(aldieId, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Desired-body-slider", "4", today.toDate());
		mygoalsList.add(thirdQuestion);
		fourthQuestion = createMygoals(aldieId, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Desired-body-items", "CurrentAndDesiredState_answer2|CurrentAndDesiredState_answer22|CurrentAndDesiredState_answer222", today.toDate());
		mygoalsList.add(fourthQuestion);
		fifthQuestion = createMygoals(aldieId, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Current-recharge-slide", "5", today.toDate());
		mygoalsList.add(fifthQuestion);
		sixthQuestion = createMygoals(aldieId, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Current-recharge-items", "CurrentAndDesiredState_answer3|CurrentAndDesiredState_answer33|CurrentAndDesiredState_answer333", today.toDate());
		mygoalsList.add(sixthQuestion);	
        return mygoalsList;
    }

    private MygoalsList createReflectionsMygoals() {
   
		MygoalsList mygoalsList = new MygoalsList();
		Mygoals firstQuestion = createMygoals(aldieId, MygoalsInventoryType.REFLECTIONS.name(), "reflection-matters", "Relflections_answer text area1", twoWeeksAgo);
		mygoalsList.add(firstQuestion);
		Mygoals secondQuestion = createMygoals(aldieId, MygoalsInventoryType.REFLECTIONS.name(), "reflection-joy", "Relflections_answer text are2", twoWeeksAgo);
		mygoalsList.add(secondQuestion);
		Mygoals thirdQuestion = createMygoals(aldieId, MygoalsInventoryType.REFLECTIONS.name(), "reflection-sorrow", "Relflections_answer text area3", twoWeeksAgo);
		mygoalsList.add(thirdQuestion);
		Mygoals fourthQuestion = createMygoals(aldieId, MygoalsInventoryType.REFLECTIONS.name(), "reflection-vision", "Relflections_answer text area4", twoWeeksAgo);
		mygoalsList.add(fourthQuestion);

		firstQuestion = createMygoals(aldieId, MygoalsInventoryType.REFLECTIONS.name(), "reflection-matters", "Relflections_answer text area1", today.toDate());
		mygoalsList.add(firstQuestion);
		secondQuestion = createMygoals(aldieId, MygoalsInventoryType.REFLECTIONS.name(), "reflection-joy", "Relflections_answer text are2", today.toDate());
		mygoalsList.add(secondQuestion);
		thirdQuestion = createMygoals(aldieId, MygoalsInventoryType.REFLECTIONS.name(), "reflection-sorrow", "Relflections_answer text area3",today.toDate());
		mygoalsList.add(thirdQuestion);
		fourthQuestion = createMygoals(aldieId, MygoalsInventoryType.REFLECTIONS.name(), "reflection-vision", "Relflections_answer text area4",today.toDate());
		mygoalsList.add(fourthQuestion);
		return mygoalsList;
    }
    
    private MygoalsList createPrioritiesMygoals() {
       	
		MygoalsList mygoalsList = new MygoalsList();
		Mygoals firstQuestion = createMygoals(aldieId, MygoalsInventoryType.PRIORITIES.name(), "area-p1", "Priorities1_area_answer", twoWeeksAgo);
		mygoalsList.add(firstQuestion);
		Mygoals secondQuestion = createMygoals(aldieId, MygoalsInventoryType.PRIORITIES.name(), "goal-p1", "Priorities1_goal_answer", twoWeeksAgo);
		mygoalsList.add(secondQuestion);
		Mygoals thirdQuestion = createMygoals(aldieId, MygoalsInventoryType.PRIORITIES.name(), "area-p2", "Priorities2_area_answer", twoWeeksAgo);
		mygoalsList.add(thirdQuestion);
		Mygoals fourthQuestion = createMygoals(aldieId, MygoalsInventoryType.PRIORITIES.name(), "goal-p2", "Priorities2_goal_answer", twoWeeksAgo);
		mygoalsList.add(fourthQuestion);
		
		firstQuestion = createMygoals(aldieId, MygoalsInventoryType.PRIORITIES.name(), "area-p1", "Priorities1_area_answer", today.toDate());
		mygoalsList.add(firstQuestion);
		secondQuestion = createMygoals(aldieId, MygoalsInventoryType.PRIORITIES.name(), "goal-p1", "Priorities1_goal_answer", today.toDate());
		mygoalsList.add(secondQuestion);
		thirdQuestion = createMygoals(aldieId, MygoalsInventoryType.PRIORITIES.name(), "area-p2", "Priorities2_area_answer", today.toDate());
		mygoalsList.add(thirdQuestion);
		fourthQuestion = createMygoals(aldieId, MygoalsInventoryType.PRIORITIES.name(), "goal-p2", "Priorities2_goal_answer", today.toDate());
		mygoalsList.add(fourthQuestion);
		return mygoalsList;
    }
    

    private Mygoals createMygoals(PatientIdentifier patientIdentifier, String invType, String questionKey, String answer, Date dateUpdated) {
    	Mygoals mygoals = new Mygoals();
    	mygoals.setPatientIdentifier(patientIdentifier);
    	mygoals.setPatientId(patientIdentifier.getUniqueId());
    	mygoals.setInventoryType(invType);
    	mygoals.setQuestionKey(questionKey);
    	mygoals.setAnswer(answer);
    	mygoals.setDateUpdated(dateUpdated);
    	mygoals.setElapsedTime(10);
        return mygoals;
    }

 
    @After
    public void cleanup() {
    	for (Mygoals feelingsMygoals : feelingsMygoalsList) {
    		feelingsMygoals.setUniqueId(feelingsMygoals.getId());
    		dataLayer.deleteMygoals(feelingsMygoals);
		}
    	for (Mygoals currentAndDesiredStateMygoals : currentAndDesiredStateMygoalsList) {
    		currentAndDesiredStateMygoals.setUniqueId(currentAndDesiredStateMygoals.getId());
    		dataLayer.deleteMygoals(currentAndDesiredStateMygoals);
		}
    	for (Mygoals reflectionsMygoals : reflectionsMygoalsList) {
    		reflectionsMygoals.setUniqueId(reflectionsMygoals.getId());
    		dataLayer.deleteMygoals(reflectionsMygoals);
		}
    	for (Mygoals prioritiesMygoals : prioritiesMygoalsList) {
    		prioritiesMygoals.setUniqueId(prioritiesMygoals.getId());
    		dataLayer.deleteMygoals(prioritiesMygoals);
		}
        
    }

    @Test
    public void saveMygoals() {
		Mygoals feelingsMygoals = createMygoals(aldieId, MygoalsInventoryType.FEELINGS.name(), "feelings-physically", "4", twoWeeksAgo);
		Mygoals mygoals = dataLayer.saveMygoals(feelingsMygoals);
		assertNotNull(mygoals);
		assertNull(feelingsMygoals.getId());
		assertNotNull(mygoals.getId());
		feelingsMygoals.setId(mygoals.getId());
		assertMygoals(feelingsMygoals, mygoals);
		
		Mygoals currAndDesireStateMygoals = createMygoals(aldieId, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), "Current-body-items", "CurrentAndDesiredState_answer11|CurrentAndDesiredState_answer22|CurrentAndDesiredState_answer33", twoWeeksAgo);
		mygoals = dataLayer.saveMygoals(currAndDesireStateMygoals);
		assertNotNull(mygoals);
		assertNull(currAndDesireStateMygoals.getId());
		assertNotNull(mygoals.getId());
		currAndDesireStateMygoals.setId(mygoals.getId());
		assertMygoals(currAndDesireStateMygoals, mygoals);

		Mygoals reflectionsMygoals = createMygoals(aldieId, MygoalsInventoryType.REFLECTIONS.name(), "reflection-matters", "Reflections Text Area1", twoWeeksAgo);
		mygoals = dataLayer.saveMygoals(reflectionsMygoals);
		assertNotNull(mygoals);
		assertNotNull(mygoals.getId());
		assertNull(reflectionsMygoals.getId());
		reflectionsMygoals.setId(mygoals.getId());
		assertMygoals(reflectionsMygoals, mygoals);
		
		Mygoals prioritiesMygoals = createMygoals(aldieId, MygoalsInventoryType.PRIORITIES.name(), "goal-p1", "Priorities1_goal_answer", twoWeeksAgo);
		mygoals = dataLayer.saveMygoals(prioritiesMygoals);
		assertNotNull(mygoals);
		assertNotNull(mygoals.getId());
		assertNull(prioritiesMygoals.getId());
		prioritiesMygoals.setId(mygoals.getId());
		assertMygoals(prioritiesMygoals, mygoals);
	
    }
    
    @Test
    public void fetchMygoals() {
    	MygoalsList mygoalsList = dataLayer.fetchMygoalsListByPatient(aldieId.getUniqueId());
    	Assert.assertTrue(mygoalsList.size() > 0);
        for (Mygoals mygoals : mygoalsList) {
			assertNotNull(mygoals.getId());
		}
    }

    @Test
    public void fetchMygoalsById() {
    	Mygoals feelingsMygoals = feelingsMygoalsList.get(0);
        Mygoals fs_mygoals = dataLayer.fetchMygoalsById(feelingsMygoals.getPatientId(), feelingsMygoals.getId());
        assertMygoals(feelingsMygoals, fs_mygoals);
    }

    private void assertMygoals(Mygoals expectedMygoals, Mygoals actualMygoals) {
    	 SimpleDateFormat dtFmt = new SimpleDateFormat("dd/MM/yy");
    	 
        assertEquals(expectedMygoals.getId(), actualMygoals.getId());
        assertEquals(expectedMygoals.getPatientId(), actualMygoals.getPatientId());
        assertEquals(expectedMygoals.getInventoryType(), actualMygoals.getInventoryType());
        assertEquals(expectedMygoals.getQuestionKey(), actualMygoals.getQuestionKey());
        assertEquals(expectedMygoals.getAnswer(), actualMygoals.getAnswer());
        assertEquals(dtFmt.format(expectedMygoals.getDateUpdated()), dtFmt.format(actualMygoals.getDateUpdated()));
        assertEquals(expectedMygoals.getElapsedTime(), actualMygoals.getElapsedTime());
 		
	}
    
    @Test
    public void fetchLatestMygoalsList() {
    	MygoalsList latestMygoalsList = dataLayer.fetchLatestMygoalsList(aldieId.getUniqueId());
    	MygoalsList invResps = dataLayer.fetchMygoalsListByPatient(aldieId.getUniqueId());
    	Assert.assertTrue(latestMygoalsList.size() > 0);
    	Assert.assertTrue(invResps.size() > 0);
        Assert.assertTrue(invResps.size() > latestMygoalsList.size());
    }   

    @Test
    public void fetchLatestMygoalsListByInventoryType() {
    	MygoalsList mygoalsList = dataLayer.fetchLatestMygoalsListByType(aldieId.getUniqueId(), MygoalsInventoryType.FEELINGS.name());
    
    	Assert.assertTrue(mygoalsList.size() > 0);
    	for (Mygoals mygoals : mygoalsList) {
    		Assert.assertEquals(MygoalsInventoryType.FEELINGS.name(), mygoals.getInventoryType());
		}

    	mygoalsList = dataLayer.fetchLatestMygoalsListByType(aldieId.getUniqueId(), MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
        
    	Assert.assertTrue(mygoalsList.size() > 0);
    	for (Mygoals mygoals : mygoalsList) {
    		Assert.assertEquals(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), mygoals.getInventoryType());
		}

    	mygoalsList = dataLayer.fetchLatestMygoalsListByType(aldieId.getUniqueId(), MygoalsInventoryType.REFLECTIONS.name());
        
    	Assert.assertTrue(mygoalsList.size() > 0);
    	for (Mygoals mygoals : mygoalsList) {
    		Assert.assertEquals(MygoalsInventoryType.REFLECTIONS.name(), mygoals.getInventoryType());
		}
    	
    	mygoalsList = dataLayer.fetchLatestMygoalsListByType(aldieId.getUniqueId(), MygoalsInventoryType.PRIORITIES.name());
        
    	Assert.assertTrue(mygoalsList.size() > 0);
    	for (Mygoals mygoals : mygoalsList) {
    		Assert.assertEquals(MygoalsInventoryType.PRIORITIES.name(), mygoals.getInventoryType());
		}
   	
    }   

}
