package com.agilex.healthcare.mobilehealthplatform.datalayer.launchpad;

import javax.annotation.Resource;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.SpringBasedIntegrationRepo;
import com.agilex.healthcare.mobilehealthplatform.domain.LaunchpadItems;
import com.agilex.healthcare.mobilehealthplatform.enumeration.RunningMode;

public class LaunchpadDataLayerRepoTest extends SpringBasedIntegrationRepo{

	@Resource
	LaunchpadItemDataLayerRepo dataLayer;
	
	@Before
	public void setUp() throws Exception {
		super.setUp();
	}
	
	@After
	public void tearDown() throws Exception {
		super.tearDown();
	}

	@Test
	public void validateVeteranLaunchpadItems() {

		LaunchpadItems launchpadItems = dataLayer.fetchLaunchpadItems(RunningMode.VETERAN);
		assertEquals(4, launchpadItems.size());
	}
	
	@Test
	public void validateProviderLaunchpadItems() {
		
		LaunchpadItems launchpadItems = dataLayer.fetchLaunchpadItems(RunningMode.PROVIDER);
		assertEquals(3, launchpadItems.size());
	}
}
